/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationSetList;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.QuintupletList;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.TripletList;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.QuintupletListImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.TripletListImpl;

public class AuthenticationSetListImpl
implements AuthenticationSetList,
MAPAsnPrimitive {
    public static final int _TAG_tripletList = 0;
    public static final int _TAG_quintupletList = 1;
    public static final String _PrimitiveName = "AuthenticationSetList";
    private TripletList tripletList;
    private QuintupletList quintupletList;
    private long mapProtocolVersion;

    public AuthenticationSetListImpl() {
    }

    public AuthenticationSetListImpl(TripletList tripletList) {
        this.tripletList = tripletList;
    }

    public AuthenticationSetListImpl(QuintupletList quintupletList) {
        this.quintupletList = quintupletList;
        this.mapProtocolVersion = 3L;
    }

    public TripletList getTripletList() {
        return this.tripletList;
    }

    public QuintupletList getQuintupletList() {
        return this.quintupletList;
    }

    public long getMapProtocolVersion() {
        return this.mapProtocolVersion;
    }

    public void setMapProtocolVersion(long mapProtocolVersion) {
        this.mapProtocolVersion = mapProtocolVersion;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mapProtocolVersion >= 3L) {
            if (this.tripletList != null) {
                return 0;
            }
            return 1;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        if (this.mapProtocolVersion >= 3L) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationSetList: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationSetList: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationSetList: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationSetList: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.tripletList = null;
        this.quintupletList = null;
        int tag = ais.getTag();
        if (ais.getTagClass() == 2) {
            switch (tag) {
                case 0: {
                    this.tripletList = new TripletListImpl();
                    ((TripletListImpl)this.tripletList).decodeData(ais, length);
                    break;
                }
                case 1: {
                    this.quintupletList = new QuintupletListImpl();
                    ((QuintupletListImpl)this.quintupletList).decodeData(ais, length);
                    break;
                }
                default: {
                    throw new MAPParsingComponentException("Error while decoding AuthenticationSetList: bad choice tag", MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            this.mapProtocolVersion = 3L;
        } else if (ais.getTagClass() == 0) {
            switch (tag) {
                case 0: 
                case 16: {
                    this.tripletList = new TripletListImpl();
                    ((TripletListImpl)this.tripletList).decodeData(ais, length);
                    break;
                }
                default: {
                    throw new MAPParsingComponentException("Error while decoding AuthenticationSetList: bad tag for MAP V2", MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            this.mapProtocolVersion = 2L;
        } else {
            throw new MAPParsingComponentException("Error while decoding AuthenticationSetList: bad choice tagClass", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationSetList: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.tripletList == null && this.quintupletList == null || this.tripletList != null && this.quintupletList != null) {
            throw new MAPException("Error while decoding AuthenticationSetList: One and only one choice must be selected");
        }
        if (this.tripletList != null) {
            ((TripletListImpl)this.tripletList).encodeData(asnOs);
        } else {
            ((QuintupletListImpl)this.quintupletList).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationSetList [");
        if (this.tripletList != null) {
            sb.append(this.tripletList.toString());
            sb.append(", ");
        }
        if (this.quintupletList != null) {
            sb.append(this.quintupletList.toString());
            sb.append(", ");
        }
        sb.append("mapProtocolVersion=");
        sb.append(this.mapProtocolVersion);
        sb.append("]");
        return sb.toString();
    }
}

