/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationQuintuplet;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class AuthenticationQuintupletImpl
implements AuthenticationQuintuplet,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "AuthenticationQuintuplet";
    private byte[] rand;
    private byte[] xres;
    private byte[] ck;
    private byte[] ik;
    private byte[] autn;

    public AuthenticationQuintupletImpl() {
    }

    public AuthenticationQuintupletImpl(byte[] rand, byte[] xres, byte[] ck, byte[] ik, byte[] autn) {
        this.rand = rand;
        this.xres = xres;
        this.ck = ck;
        this.ik = ik;
        this.autn = autn;
    }

    public byte[] getRand() {
        return this.rand;
    }

    public byte[] getXres() {
        return this.xres;
    }

    public byte[] getCk() {
        return this.ck;
    }

    public byte[] getIk() {
        return this.ik;
    }

    public byte[] getAutn() {
        return this.autn;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.rand = null;
        this.xres = null;
        this.ck = null;
        this.ik = null;
        this.autn = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.rand: Parameter 0 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.rand = ais.readOctetString();
                    if (this.rand.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.rand: Bad field length: 16 is needed, found: " + this.rand.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.xres: Parameter 1 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.xres = ais.readOctetString();
                    if (this.xres.length >= 4 && this.xres.length <= 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.xres: Bad field length: 4-16 is needed, found: " + this.xres.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 2: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.ck: Parameter 2 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ck = ais.readOctetString();
                    if (this.ck.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.ck: Bad field length: 16 is needed, found: " + this.ck.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 3: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.ik: Parameter 3 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ik = ais.readOctetString();
                    if (this.ik.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.ik: Bad field length: 16 is needed, found: " + this.ik.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
                case 4: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.autn: Parameter 4 bad tag or tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.autn = ais.readOctetString();
                    if (this.autn.length == 16) break;
                    throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet.autn: Bad field length: 16 is needed, found: " + this.autn.length, MAPParsingComponentExceptionReason.MistypedParameter);
                }
            }
            ++num;
        }
        if (num < 5) {
            throw new MAPParsingComponentException("Error while decoding AuthenticationQuintuplet: Needs at least 5 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.rand == null || this.xres == null || this.ck == null || this.ik == null || this.autn == null) {
            throw new MAPException("rand, xres, ck, ik and autn fields must not be null");
        }
        if (this.rand.length != 16) {
            throw new MAPException("Wrong rand field length: must be 16, found " + this.rand.length);
        }
        if (this.xres.length < 4 || this.xres.length > 16) {
            throw new MAPException("Wrong xres field length: must be from 4 to 16, found " + this.xres.length);
        }
        if (this.ck.length != 16) {
            throw new MAPException("Wrong ck field length: must be 16, found " + this.ck.length);
        }
        if (this.ik.length != 16) {
            throw new MAPException("Wrong ik field length: must be 16, found " + this.ik.length);
        }
        if (this.autn.length != 16) {
            throw new MAPException("Wrong autn field length: must be 16, found " + this.autn.length);
        }
        try {
            asnOs.writeOctetString(this.rand);
            asnOs.writeOctetString(this.xres);
            asnOs.writeOctetString(this.ck);
            asnOs.writeOctetString(this.ik);
            asnOs.writeOctetString(this.autn);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationQuintuplet: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthenticationQuintuplet [");
        if (this.rand != null) {
            sb.append("rand=[");
            sb.append(this.printDataArr(this.rand));
            sb.append("], ");
        }
        if (this.xres != null) {
            sb.append("xres=[");
            sb.append(this.printDataArr(this.xres));
            sb.append("], ");
        }
        if (this.ck != null) {
            sb.append("ck=[");
            sb.append(this.printDataArr(this.ck));
            sb.append("], ");
        }
        if (this.ik != null) {
            sb.append("ik=[");
            sb.append(this.printDataArr(this.ik));
            sb.append("], ");
        }
        if (this.autn != null) {
            sb.append("autn=[");
            sb.append(this.printDataArr(this.autn));
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

