/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.MAPServiceBaseImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPServiceMobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPServiceMobilityListener;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ForwardCheckSSIndicationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ResetRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeRequest_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeResponse_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MAPDialogMobilityImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.AuthenticationFailureReportRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.AuthenticationFailureReportResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.SendAuthenticationInfoRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.authentication.SendAuthenticationInfoResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.faultRecovery.ForwardCheckSSIndicationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.faultRecovery.ResetRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.faultRecovery.RestoreDataRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.faultRecovery.RestoreDataResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.imei.CheckImeiRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.imei.CheckImeiResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.CancelLocationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.CancelLocationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.PurgeMSRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.PurgeMSResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SendIdentificationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.SendIdentificationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.UpdateGprsLocationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.UpdateGprsLocationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.UpdateLocationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.locationManagement.UpdateLocationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.oam.ActivateTraceModeRequestImpl_Mobility;
import org.mobicents.protocols.ss7.map.service.mobility.oam.ActivateTraceModeResponseImpl_Mobility;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.AnyTimeInterrogationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.AnyTimeInterrogationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.ProvideSubscriberInfoRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.ProvideSubscriberInfoResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.DeleteSubscriberDataRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.DeleteSubscriberDataResponseImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.InsertSubscriberDataRequestImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.InsertSubscriberDataResponseImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class MAPServiceMobilityImpl
extends MAPServiceBaseImpl
implements MAPServiceMobility {
    protected Logger loger = Logger.getLogger(MAPServiceMobilityImpl.class);

    public MAPServiceMobilityImpl(MAPProviderImpl mapProviderImpl) {
        super(mapProviderImpl);
    }

    public MAPDialogMobility createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference) throws MAPException {
        return this.createNewDialog(appCntx, origAddress, origReference, destAddress, destReference, null);
    }

    public MAPDialogMobility createNewDialog(MAPApplicationContext appCntx, SccpAddress origAddress, AddressString origReference, SccpAddress destAddress, AddressString destReference, Long localTrId) throws MAPException {
        if (!this.isActivated()) {
            throw new MAPException("Cannot create MAPDialogMobility because MAPServiceMobility is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        MAPDialogMobilityImpl dialog = new MAPDialogMobilityImpl(appCntx, tcapDialog, this.mapProviderImpl, this, origReference, destReference);
        this.putMAPDialogIntoCollection(dialog);
        return dialog;
    }

    @Override
    protected MAPDialogImpl createNewDialogIncoming(MAPApplicationContext appCntx, Dialog tcapDialog) {
        return new MAPDialogMobilityImpl(appCntx, tcapDialog, this.mapProviderImpl, this, null, null);
    }

    public void addMAPServiceListener(MAPServiceMobilityListener mapServiceListener) {
        super.addMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public void removeMAPServiceListener(MAPServiceMobilityListener mapServiceListener) {
        super.removeMAPServiceListener((MAPServiceListener)mapServiceListener);
    }

    public ServingCheckData isServingService(MAPApplicationContext dialogApplicationContext) {
        MAPApplicationContextName ctx = dialogApplicationContext.getApplicationContextName();
        int vers = dialogApplicationContext.getApplicationContextVersion().getVersion();
        switch (ctx) {
            case infoRetrievalContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case authenticationFailureReportContext: {
                if (vers >= 3 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case networkLocUpContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case locationCancellationContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case interVlrInfoRetrievalContext: {
                if (vers >= 2 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case gprsLocationUpdateContext: {
                if (vers == 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case msPurgingContext: {
                if (vers >= 2 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case resetContext: {
                if (vers >= 1 && vers <= 2) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 2) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case equipmentMngtContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case anyTimeEnquiryContext: 
            case anyTimeInfoHandlingContext: 
            case subscriberInfoEnquiryContext: {
                if (vers >= 3 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
            case subscriberDataMngtContext: {
                if (vers >= 1 && vers <= 3) {
                    return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
                }
                if (vers > 3) {
                    long[] altOid = dialogApplicationContext.getOID();
                    altOid[7] = 3L;
                    ApplicationContextName alt = TcapFactory.createApplicationContextName((long[])altOid);
                    return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect, alt);
                }
                return new ServingCheckDataImpl(ServingCheckResult.AC_VersionIncorrect);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    @Override
    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        switch (operationCode) {
            case 2: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.networkLocUpContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 3: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.locationCancellationContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 9: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.infoRetrievalContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 37: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.resetContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 43: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.equipmentMngtContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
            case 7: 
            case 8: {
                return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.subscriberDataMngtContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version1);
            }
        }
        return null;
    }

    @Override
    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, MAPDialog mapDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws MAPParsingComponentException {
        MAPDialogMobilityImpl mapDialogMobilityImpl = (MAPDialogMobilityImpl)mapDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new MAPParsingComponentException("", MAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        MAPApplicationContextName acn = mapDialog.getApplicationContext().getApplicationContextName();
        int vers = mapDialog.getApplicationContext().getApplicationContextVersion().getVersion();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 2: {
                if (acn != MAPApplicationContextName.networkLocUpContext) break;
                if (compType == ComponentType.Invoke) {
                    this.updateLocationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.updateLocationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 3: {
                if (acn != MAPApplicationContextName.locationCancellationContext) break;
                if (compType == ComponentType.Invoke) {
                    this.cancelLocationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.cancelLocationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 55: {
                if (acn != MAPApplicationContextName.interVlrInfoRetrievalContext) break;
                if (compType == ComponentType.Invoke) {
                    this.SendIdentificationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.SendIdentificationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 23: {
                if (acn != MAPApplicationContextName.gprsLocationUpdateContext) break;
                if (compType == ComponentType.Invoke) {
                    this.updateGprsLocationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.updateGprsLocationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 67: {
                if (acn != MAPApplicationContextName.msPurgingContext) break;
                if (compType == ComponentType.Invoke) {
                    this.purgeMSRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.purgeMSResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 56: {
                if (acn != MAPApplicationContextName.infoRetrievalContext || vers < 2) break;
                if (compType == ComponentType.Invoke) {
                    this.sendAuthenticationInfoRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.sendAuthenticationInfoResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 15: {
                if (acn != MAPApplicationContextName.authenticationFailureReportContext || vers < 3) break;
                if (compType == ComponentType.Invoke) {
                    this.authenticationFailureReportRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.authenticationFailureReportResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 37: {
                if (acn != MAPApplicationContextName.resetContext || vers > 2 || compType != ComponentType.Invoke) break;
                this.resetRequest(parameter, mapDialogMobilityImpl, invokeId);
                break;
            }
            case 38: {
                if (acn != MAPApplicationContextName.networkLocUpContext || compType != ComponentType.Invoke) break;
                this.forwardCheckSsIndicationRequest(parameter, mapDialogMobilityImpl, invokeId);
                break;
            }
            case 57: {
                if (acn != MAPApplicationContextName.networkLocUpContext || vers < 2) break;
                if (compType == ComponentType.Invoke) {
                    this.restoreDataRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.restoreDataResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 71: {
                if (acn != MAPApplicationContextName.anyTimeEnquiryContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processAnyTimeInterrogationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processAnyTimeInterrogationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 62: {
                if (acn != MAPApplicationContextName.anyTimeInfoHandlingContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processAnyTimeSubscriptionInterrogationRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processAnyTimeSubscriptionInterrogationResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 70: {
                if (acn != MAPApplicationContextName.subscriberInfoEnquiryContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processProvideSubscriberInfoRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processProvideSubscriberInfoResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 43: {
                if (acn != MAPApplicationContextName.equipmentMngtContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processCheckImeiRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processCheckImeiResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 7: {
                if (acn != MAPApplicationContextName.subscriberDataMngtContext && acn != MAPApplicationContextName.networkLocUpContext && acn != MAPApplicationContextName.gprsLocationUpdateContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processInsertSubscriberDataRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processInsertSubscriberDataResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 8: {
                if (acn != MAPApplicationContextName.subscriberDataMngtContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processDeleteSubscriberDataRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processDeleteSubscriberDataResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            case 50: {
                if (acn != MAPApplicationContextName.networkLocUpContext && acn != MAPApplicationContextName.gprsLocationUpdateContext) break;
                if (compType == ComponentType.Invoke) {
                    this.processActivateTraceModeRequest(parameter, mapDialogMobilityImpl, invokeId);
                    break;
                }
                this.processActivateTraceModeResponse(parameter, mapDialogMobilityImpl, invokeId, compType == ComponentType.ReturnResult);
                break;
            }
            default: {
                throw new MAPParsingComponentException("MAPServiceMobility: unknown incoming operation code: " + ocValueInt, MAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void updateLocationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding updateLocationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding updateLocationRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UpdateLocationRequestImpl ind = new UpdateLocationRequestImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onUpdateLocationRequest((UpdateLocationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing updateLocationRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void updateLocationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding updateLocationResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version >= 2L) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding updateLocationResponse V2_3: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding updateLocationResponse V1: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        UpdateLocationResponseImpl ind = new UpdateLocationResponseImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onUpdateLocationResponse((UpdateLocationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing updateLocationResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void cancelLocationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding cancelLocationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 3L ? parameter.getTag() != 3 || parameter.getTagClass() != 2 || parameter.isPrimitive() : parameter.getTag() != 16 && parameter.getTag() != 4 || parameter.getTagClass() != 0) {
            throw new MAPParsingComponentException("Error while decoding cancelLocationRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        CancelLocationRequestImpl ind = new CancelLocationRequestImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onCancelLocationRequest((CancelLocationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing cancelLocationRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void cancelLocationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        CancelLocationResponseImpl ind = new CancelLocationResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding cancelLocationResponse V2_3: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onCancelLocationResponse((CancelLocationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing cancelLocationResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void SendIdentificationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding sendIdentificationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 3L) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding sendIdentificationRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendIdentificationRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        SendIdentificationRequestImpl ind = new SendIdentificationRequestImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onSendIdentificationRequest((SendIdentificationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing sendIdentificationRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void SendIdentificationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        SendIdentificationResponseImpl ind = new SendIdentificationResponseImpl(version);
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding SendIdentificationResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 3L ? parameter.getTag() != 3 || parameter.getTagClass() != 2 || parameter.isPrimitive() : parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding sendIdentificationResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onSendIdentificationResponse((SendIdentificationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing sendIdentificationResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void updateGprsLocationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding updateGprsLocationRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 3L && (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive())) {
            throw new MAPParsingComponentException("Error while decoding updateGprsLocationRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        UpdateGprsLocationRequestImpl ind = new UpdateGprsLocationRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onUpdateGprsLocationRequest((UpdateGprsLocationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing UpdateGprsLocationRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void updateGprsLocationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        UpdateGprsLocationResponseImpl ind = new UpdateGprsLocationResponseImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding updateGprsLocationResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding updateGprsLocationResponse V3: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onUpdateGprsLocationResponse((UpdateGprsLocationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing UpdateGprsLocationResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void purgeMSRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding PurgeMSRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 3L && (parameter.getTag() != 3 || parameter.getTagClass() != 2 || parameter.isPrimitive())) {
            throw new MAPParsingComponentException("Error while decoding PurgeMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (version == 2L && (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive())) {
            throw new MAPParsingComponentException("Error while decoding PurgeMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf, parameter.getTagClass(), parameter.isPrimitive(), parameter.getTag());
        PurgeMSRequestImpl ind = new PurgeMSRequestImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onPurgeMSRequest((PurgeMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing PurgeMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void purgeMSResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        PurgeMSResponseImpl ind = new PurgeMSResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding PurgeMSResponse V3: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onPurgeMSResponse((PurgeMSResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing PurgeMSResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void sendAuthenticationInfoRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        AsnInputStream ais;
        byte[] buf;
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        SendAuthenticationInfoRequestImpl ind = new SendAuthenticationInfoRequestImpl(version);
        if (version >= 3L) {
            if (parameter != null) {
                if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding sendAuthenticationInfoRequest V3: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                }
                buf = parameter.getData();
                ais = new AsnInputStream(buf);
                ind.decodeData(ais, buf.length);
            }
        } else {
            if (parameter == null) {
                throw new MAPParsingComponentException("Error while decoding sendAuthenticationInfoRequest V2: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
            }
            if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding sendAuthenticationInfoRequest V2: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            buf = parameter.getData();
            ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onSendAuthenticationInfoRequest((SendAuthenticationInfoRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing sendAuthenticationInfoRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void sendAuthenticationInfoResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        AsnInputStream ais;
        byte[] buf;
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        SendAuthenticationInfoResponseImpl ind = new SendAuthenticationInfoResponseImpl(version);
        if (version >= 3L) {
            if (parameter != null) {
                if (parameter.getTag() != 3 || parameter.getTagClass() != 2 || parameter.isPrimitive()) {
                    throw new MAPParsingComponentException("Error while decoding sendAuthenticationInfoResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
                }
                buf = parameter.getData();
                ais = new AsnInputStream(buf);
                ind.decodeData(ais, buf.length);
            }
        } else if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding sendAuthenticationInfoResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            buf = parameter.getData();
            ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onSendAuthenticationInfoResponse((SendAuthenticationInfoResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing sendAuthenticationInfoResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void authenticationFailureReportRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        AuthenticationFailureReportRequestImpl ind = new AuthenticationFailureReportRequestImpl();
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding authenticationFailureReportRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding authenticationFailureReportRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAuthenticationFailureReportRequest((AuthenticationFailureReportRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing authenticationFailureReportRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void authenticationFailureReportResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        AuthenticationFailureReportResponseImpl ind = new AuthenticationFailureReportResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding authenticationFailureReportResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAuthenticationFailureReportResponse((AuthenticationFailureReportResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing authenticationFailureReportResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void resetRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding resetRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding resetRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        ResetRequestImpl ind = new ResetRequestImpl(version);
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onResetRequest((ResetRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing resetRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void forwardCheckSsIndicationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        ForwardCheckSSIndicationRequestImpl ind = new ForwardCheckSSIndicationRequestImpl();
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onForwardCheckSSIndicationRequest((ForwardCheckSSIndicationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing forwardCheckSsIndicationRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void restoreDataRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding restoreDataRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding restoreDataRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        RestoreDataRequestImpl ind = new RestoreDataRequestImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onRestoreDataRequest((RestoreDataRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing restoreDataRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void restoreDataResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding restoreDataResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding restoreDataResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        RestoreDataResponseImpl ind = new RestoreDataResponseImpl();
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onRestoreDataResponse((RestoreDataResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing restoreDataResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processAnyTimeInterrogationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        AnyTimeInterrogationRequestImpl ind = new AnyTimeInterrogationRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAnyTimeInterrogationRequest((AnyTimeInterrogationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing AnyTimeInterrogationRequestIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processAnyTimeInterrogationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeInterrogationResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        AnyTimeInterrogationResponseImpl ind = new AnyTimeInterrogationResponseImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAnyTimeInterrogationResponse((AnyTimeInterrogationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing AnyTimeInterrogationResponseIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processAnyTimeSubscriptionInterrogationRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequestIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationRequestIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        AnyTimeSubscriptionInterrogationRequestImpl ind = new AnyTimeSubscriptionInterrogationRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAnyTimeSubscriptionInterrogationRequest((AnyTimeSubscriptionInterrogationRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing AnyTimeSubscriptionInterrogationRequestIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processAnyTimeSubscriptionInterrogationResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding AnyTimeSubscriptionInterrogationResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        AnyTimeSubscriptionInterrogationResponseImpl ind = new AnyTimeSubscriptionInterrogationResponseImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onAnyTimeSubscriptionInterrogationResponse((AnyTimeSubscriptionInterrogationResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing AnyTimeSubscriptionInterrogationResponseIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processProvideSubscriberInfoRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberInfoRequestImpl ind = new ProvideSubscriberInfoRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onProvideSubscriberInfoRequest((ProvideSubscriberInfoRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing ProvideSubscriberInfoRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processProvideSubscriberInfoResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoResponseIndication: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding ProvideSubscriberInfoResponseIndication: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ProvideSubscriberInfoResponseImpl ind = new ProvideSubscriberInfoResponseImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onProvideSubscriberInfoResponse((ProvideSubscriberInfoResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing ProvideSubscriberInfoResponseIndication: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processCheckImeiRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding CheckImeiRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (version >= 3L) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding CheckImeiRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding CheckImeiRequest V1 or V2: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        CheckImeiRequestImpl ind = new CheckImeiRequestImpl(version);
        ind.decodeData(ais, parameter.getEncodingLength());
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onCheckImeiRequest((CheckImeiRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processCheckImeiRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processCheckImeiResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding CheckImeiResponse: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (version >= 3L) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding CheckImeiResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        } else if (parameter.getTag() != 10 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding CheckImeiResponse: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        CheckImeiResponseImpl ind = new CheckImeiResponseImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onCheckImeiResponse((CheckImeiResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processCheckImeiResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processInsertSubscriberDataRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        InsertSubscriberDataRequestImpl ind = new InsertSubscriberDataRequestImpl(version);
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onInsertSubscriberDataRequest((InsertSubscriberDataRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processInsertSubscriberDataRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processInsertSubscriberDataResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        long version = mapDialogImpl.getApplicationContext().getApplicationContextVersion().getVersion();
        InsertSubscriberDataResponseImpl ind = new InsertSubscriberDataResponseImpl(version);
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding InsertSubscriberDataResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onInsertSubscriberDataResponse((InsertSubscriberDataResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processInsertSubscriberDataResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processDeleteSubscriberDataRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding DeleteSubscriberDataRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding DeleteSubscriberDataRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        DeleteSubscriberDataRequestImpl ind = new DeleteSubscriberDataRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onDeleteSubscriberDataRequest((DeleteSubscriberDataRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processDeleteSubscriberDataRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processDeleteSubscriberDataResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        DeleteSubscriberDataResponseImpl ind = new DeleteSubscriberDataResponseImpl();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding DeleteSubscriberDataResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onDeleteSubscriberDataResponse((DeleteSubscriberDataResponse)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processDeleteSubscriberDataResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processActivateTraceModeRequest(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId) throws MAPParsingComponentException {
        if (parameter == null) {
            throw new MAPParsingComponentException("Error while decoding processActivateTraceModeRequest: Parameter is mandatory but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding processActivateTraceModeRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ActivateTraceModeRequestImpl_Mobility ind = new ActivateTraceModeRequestImpl_Mobility();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onActivateTraceModeRequest_Mobility((ActivateTraceModeRequest_Mobility)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processActivateTraceModeRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processActivateTraceModeResponse(Parameter parameter, MAPDialogMobilityImpl mapDialogImpl, Long invokeId, boolean returnResultNotLast) throws MAPParsingComponentException {
        ActivateTraceModeResponseImpl_Mobility ind = new ActivateTraceModeResponseImpl_Mobility();
        if (parameter != null) {
            if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
                throw new MAPParsingComponentException("Error while decoding processActivateTraceModeResponse: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
            byte[] buf = parameter.getData();
            AsnInputStream ais = new AsnInputStream(buf);
            ind.decodeData(ais, buf.length);
        }
        ind.setInvokeId(invokeId);
        ind.setMAPDialog(mapDialogImpl);
        ind.setReturnResultNotLast(returnResultNotLast);
        for (MAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onMAPMessage((MAPMessage)ind);
                ((MAPServiceMobilityListener)serLis).onActivateTraceModeResponse_Mobility((ActivateTraceModeResponse_Mobility)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing processActivateTraceModeResponse: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

