/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSRequest;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SubscriberIdentityImpl;
import org.mobicents.protocols.ss7.map.service.lsm.LsmMessageImpl;

public class SendRoutingInfoForLCSRequestImpl
extends LsmMessageImpl
implements SendRoutingInfoForLCSRequest {
    private static final int _TAG_MLC_NUMBER = 0;
    private static final int _TAG_TARGET_MS = 1;
    private static final int _TAG_EXTENSION_CONTAINER = 2;
    public static final String _PrimitiveName = "SendRoutingInfoForLCSRequest";
    private MAPExtensionContainer extensionContainer;
    private SubscriberIdentity targetMS;
    private ISDNAddressString mlcNumber;

    public SendRoutingInfoForLCSRequestImpl() {
    }

    public SendRoutingInfoForLCSRequestImpl(ISDNAddressString mlcNumber, SubscriberIdentity targetMS) {
        this.targetMS = targetMS;
        this.mlcNumber = mlcNumber;
    }

    public SendRoutingInfoForLCSRequestImpl(ISDNAddressString mlcNumber, SubscriberIdentity targetMS, MAPExtensionContainer extensionContainer) {
        this(mlcNumber, targetMS);
        this.extensionContainer = extensionContainer;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.sendRoutingInfoForLCS_Request;
    }

    public int getOperationCode() {
        return 85;
    }

    public ISDNAddressString getMLCNumber() {
        return this.mlcNumber;
    }

    public SubscriberIdentity getTargetMS() {
        return this.targetMS;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForLCSRequest: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForLCSRequest: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SendRoutingInfoForLCSRequest: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SendRoutingInfoForLCSRequest: ", (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.extensionContainer = null;
        this.targetMS = null;
        this.mlcNumber = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSRequest: Parameter [mlcNumber [0] ISDN-AddressString] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.mlcNumber = new ISDNAddressStringImpl();
        ((ISDNAddressStringImpl)this.mlcNumber).decodeAll(ais);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSRequest: Parameter [targetMS [1] SubscriberIdentity] bad tag class or not primitive or not Sequence", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.targetMS = new SubscriberIdentityImpl();
        AsnInputStream ais2 = ais.readSequenceStream();
        ais2.readTag();
        ((SubscriberIdentityImpl)this.targetMS).decodeAll(ais2);
        block3: while (ais.available() != 0) {
            tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding SendRoutingInfoForLCSRequest: Parameter [extensionContainer [2] ExtensionContainer] is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block3;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SendRoutingInfoForLCSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.mlcNumber == null) {
            throw new MAPException("Encoding of SendRoutingInfoForLCSRequest failed. Manadatory parameter mlcNumber [0] ISDN-AddressString is not set");
        }
        if (this.targetMS == null) {
            throw new MAPException("Encoding of SendRoutingInfoForLCSRequest failed. Manadatory parameter targetMS [1] SubscriberIdentity is not set");
        }
        ((ISDNAddressStringImpl)this.mlcNumber).encodeAll(asnOs, 2, 0);
        try {
            asnOs.writeTag(2, false, 1);
            int pos = asnOs.StartContentDefiniteLength();
            ((SubscriberIdentityImpl)this.targetMS).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException while encoding parameter targetMS [1] SubscriberIdentity");
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.mlcNumber != null) {
            sb.append("mlcNumber");
            sb.append(this.mlcNumber);
        }
        if (this.targetMS != null) {
            sb.append(", targetMS=");
            sb.append(this.targetMS);
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        sb.append("]");
        return sb.toString();
    }
}

