/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.lsm;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSFormatIndicator;
import org.mobicents.protocols.ss7.map.api.service.lsm.LCSRequestorID;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.USSDStringImpl;

public class LCSRequestorIDImpl
implements LCSRequestorID,
MAPAsnPrimitive {
    private static final int _TAG_DATA_CODING_SCHEME = 0;
    private static final int _TAG_NAME_STRING = 1;
    private static final int _TAG_LCS_FORMAT_INDICATOR = 2;
    public static final String _PrimitiveName = "LCSRequestorID";
    private CBSDataCodingScheme dataCodingScheme;
    private USSDString requestorIDString;
    private LCSFormatIndicator lcsFormatIndicator;

    public LCSRequestorIDImpl() {
    }

    public LCSRequestorIDImpl(CBSDataCodingScheme dataCodingScheme, USSDString requestorIDString, LCSFormatIndicator lcsFormatIndicator) {
        this.dataCodingScheme = dataCodingScheme;
        this.requestorIDString = requestorIDString;
        this.lcsFormatIndicator = lcsFormatIndicator;
    }

    public CBSDataCodingScheme getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    public USSDString getRequestorIDString() {
        return this.requestorIDString;
    }

    public LCSFormatIndicator getLCSFormatIndicator() {
        return this.lcsFormatIndicator;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSRequestorID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSRequestorID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LCSRequestorID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LCSRequestorID: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.dataCodingScheme = null;
        this.requestorIDString = null;
        this.lcsFormatIndicator = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 0) {
            throw new MAPParsingComponentException("Error while decoding LCSRequestorID: Parameter 0[dataCodingScheme [0] USSD-DataCodingScheme] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        int length1 = ais.readLength();
        this.dataCodingScheme = new CBSDataCodingSchemeImpl(ais.readOctetStringData(length1)[0]);
        tag = ais.readTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive() || tag != 1) {
            throw new MAPParsingComponentException("Error while decoding LCSRequestorID: Parameter 1[requestorIDString [1] RequestorIDString] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.requestorIDString = new USSDStringImpl(this.dataCodingScheme);
        ((USSDStringImpl)this.requestorIDString).decodeAll(ais);
        block3: while (ais.available() != 0) {
            tag = ais.readTag();
            switch (tag) {
                case 2: {
                    if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding LCSRequestorID: Parameter 2[lcs-FormatIndicator [2] LCS-FormatIndicator OPTIONAL] bad tag class, tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    length1 = ais.readLength();
                    this.lcsFormatIndicator = LCSFormatIndicator.getLCSFormatIndicator((int)((int)ais.readIntegerData(length1)));
                    continue block3;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSRequestorID: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.requestorIDString == null) {
            throw new MAPException("nameString must not be null");
        }
        try {
            asnOs.writeOctetString(2, 0, new byte[]{(byte)this.dataCodingScheme.getCode()});
            ((USSDStringImpl)this.requestorIDString).encodeAll(asnOs, 2, 1);
            if (this.lcsFormatIndicator != null) {
                asnOs.writeInteger(2, 2, (long)this.lcsFormatIndicator.getIndicator());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding LCSRequestorID", (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LCSRequestorID", (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataCodingScheme.getCode();
        result = 31 * result + (this.lcsFormatIndicator == null ? 0 : this.lcsFormatIndicator.hashCode());
        result = 31 * result + (this.requestorIDString == null ? 0 : this.requestorIDString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LCSRequestorIDImpl other = (LCSRequestorIDImpl)obj;
        if (this.dataCodingScheme.getCode() != other.dataCodingScheme.getCode()) {
            return false;
        }
        if (this.lcsFormatIndicator != other.lcsFormatIndicator) {
            return false;
        }
        return !(this.requestorIDString == null ? other.requestorIDString != null : !this.requestorIDString.equals(other.requestorIDString));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        sb.append("dataCodingScheme=");
        sb.append(this.dataCodingScheme);
        if (this.requestorIDString != null) {
            sb.append(", requestorIDString=");
            sb.append(this.requestorIDString.toString());
        }
        if (this.lcsFormatIndicator != null) {
            sb.append(", lcsFormatIndicator=");
            sb.append(this.lcsFormatIndicator.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

