/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.primitives;

import java.io.IOException;
import java.util.Arrays;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPPrivateExtension;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.OidContainer;

public class MAPPrivateExtensionImpl
implements MAPPrivateExtension,
MAPAsnPrimitive {
    private static final String OID = "oid";
    private static final String DATA = "data";
    private static final String DEFAULT_STRING = null;
    private long[] oId;
    private byte[] data;
    protected static final XMLFormat<MAPPrivateExtensionImpl> MAP_PRIVATE_EXTENSION_XML = new XMLFormat<MAPPrivateExtensionImpl>(MAPPrivateExtensionImpl.class){

        public void read(XMLFormat.InputElement xml, MAPPrivateExtensionImpl mapPrivateExtension) throws XMLStreamException {
            ByteArrayContainer bc;
            String globalCode = xml.getAttribute(MAPPrivateExtensionImpl.OID, DEFAULT_STRING);
            if (globalCode != null) {
                OidContainer oid = new OidContainer();
                try {
                    oid.parseSerializedData(globalCode);
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException("NumberFormatException when parsing oid in MAPPrivateExtension", (Throwable)e);
                }
                MAPPrivateExtensionImpl.access$102(mapPrivateExtension, oid.getData());
            }
            if ((bc = (ByteArrayContainer)xml.get(MAPPrivateExtensionImpl.DATA, ByteArrayContainer.class)) != null) {
                MAPPrivateExtensionImpl.access$202(mapPrivateExtension, bc.getData());
            }
        }

        public void write(MAPPrivateExtensionImpl mapPrivateExtension, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (mapPrivateExtension.oId != null) {
                OidContainer oid = new OidContainer(mapPrivateExtension.oId);
                xml.setAttribute(MAPPrivateExtensionImpl.OID, oid.getSerializedData());
            }
            if (mapPrivateExtension.data != null) {
                ByteArrayContainer bac = new ByteArrayContainer(mapPrivateExtension.data);
                xml.add((Object)bac, MAPPrivateExtensionImpl.DATA, ByteArrayContainer.class);
            }
        }
    };

    public MAPPrivateExtensionImpl() {
    }

    public MAPPrivateExtensionImpl(long[] oId, byte[] data) {
        this.oId = oId;
        this.data = data;
    }

    public long[] getOId() {
        return this.oId;
    }

    public void setOId(long[] oId) {
        this.oId = oId;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStream();
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            AsnInputStream ais = ansIS.readSequenceStreamData(length);
            this._decode(ais);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding PrivateExtension: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS) throws MAPParsingComponentException, IOException, AsnException {
        int tag = ansIS.readTag();
        if (tag != 6 || ansIS.getTagClass() != 0 || !ansIS.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding PrivateExtension: bad tag, tagClass or primitiveFactor of ExtentionId", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.oId = ansIS.readObjectIdentifier();
        if (ansIS.available() > 0) {
            this.data = new byte[ansIS.available()];
            ansIS.read(this.data);
        } else {
            this.data = null;
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.oId == null || this.oId.length < 2) {
            throw new MAPException("Error when encoding PrivateExtension: OId value must not be empty when coding PrivateExtension");
        }
        try {
            asnOs.writeObjectIdentifier(this.oId);
            if (this.data != null) {
                asnOs.write(this.data);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding PrivateExtension: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrivateExtension [");
        if (this.oId != null || this.oId.length > 0) {
            sb.append("Oid=");
            sb.append(this.ArrayToString(this.oId));
        }
        if (this.data != null) {
            sb.append(", data=");
            sb.append(this.ArrayToString(this.data));
        }
        sb.append("]");
        return sb.toString();
    }

    private String ArrayToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (byte b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }

    private String ArrayToString(long[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (long b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + Arrays.hashCode(this.oId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MAPPrivateExtensionImpl other = (MAPPrivateExtensionImpl)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return Arrays.equals(this.oId, other.oId);
    }

    static /* synthetic */ long[] access$102(MAPPrivateExtensionImpl x0, long[] x1) {
        x0.oId = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$202(MAPPrivateExtensionImpl x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

