/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageBusySubscriber;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageBusySubscriberImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageBusySubscriber {
    private static final String CCBS_POSSIBLE = "ccbsPossible";
    private static final String CCBS_BUSY = "ccbsBusy";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    public static final int _tag_ccbs_Possible = 0;
    public static final int _tag_ccbs_Busy = 1;
    private MAPExtensionContainer extensionContainer;
    private boolean ccbsPossible;
    private boolean ccbsBusy;
    protected String _PrimitiveName = "MAPErrorMessageBusySubscriber";
    protected static final XMLFormat<MAPErrorMessageBusySubscriberImpl> MAP_ERROR_MESSAGE_BUSY_SUBSCRIBER_XML = new XMLFormat<MAPErrorMessageBusySubscriberImpl>(MAPErrorMessageBusySubscriberImpl.class){

        public void read(XMLFormat.InputElement xml, MAPErrorMessageBusySubscriberImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
            errorMessage.ccbsPossible = (Boolean)xml.get(MAPErrorMessageBusySubscriberImpl.CCBS_POSSIBLE, Boolean.class);
            errorMessage.ccbsBusy = (Boolean)xml.get(MAPErrorMessageBusySubscriberImpl.CCBS_BUSY, Boolean.class);
            errorMessage.extensionContainer = (MAPExtensionContainer)xml.get(MAPErrorMessageBusySubscriberImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        public void write(MAPErrorMessageBusySubscriberImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
            xml.add((Object)errorMessage.getCcbsPossible(), MAPErrorMessageBusySubscriberImpl.CCBS_POSSIBLE, Boolean.class);
            xml.add((Object)errorMessage.getCcbsBusy(), MAPErrorMessageBusySubscriberImpl.CCBS_BUSY, Boolean.class);
            xml.add((Object)((MAPExtensionContainerImpl)errorMessage.extensionContainer), MAPErrorMessageBusySubscriberImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageBusySubscriberImpl(MAPExtensionContainer extensionContainer, boolean ccbsPossible, boolean ccbsBusy) {
        super(45L);
        this.extensionContainer = extensionContainer;
        this.ccbsPossible = ccbsPossible;
        this.ccbsBusy = ccbsBusy;
    }

    public MAPErrorMessageBusySubscriberImpl() {
        super(45L);
    }

    @Override
    public boolean isEmBusySubscriber() {
        return true;
    }

    @Override
    public MAPErrorMessageBusySubscriber getEmBusySubscriber() {
        return this;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getCcbsPossible() {
        return this.ccbsPossible;
    }

    public boolean getCcbsBusy() {
        return this.ccbsBusy;
    }

    public void setExtensionContainer(MAPExtensionContainer val) {
        this.extensionContainer = val;
    }

    public void setCcbsPossible(boolean val) {
        this.ccbsPossible = val;
    }

    public void setCcbsBusy(boolean val) {
        this.ccbsBusy = val;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.extensionContainer = null;
        this.ccbsPossible = false;
        this.ccbsBusy = false;
        if (localAis.getTagClass() != 0 || localAis.getTag() != 16 || localAis.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error decoding " + this._PrimitiveName + ": bad tag class or tag or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        AsnInputStream ais = localAis.readSequenceStreamData(length);
        block11: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 0: {
                    switch (tag) {
                        case 16: {
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
                case 2: {
                    switch (tag) {
                        case 0: {
                            ais.readNull();
                            this.ccbsPossible = true;
                            continue block11;
                        }
                        case 1: {
                            ais.readNull();
                            this.ccbsBusy = true;
                            continue block11;
                        }
                    }
                    ais.advanceElement();
                    continue block11;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (!this.ccbsPossible && !this.ccbsBusy && this.extensionContainer == null) {
            return;
        }
        try {
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.ccbsPossible) {
                asnOs.writeNull(2, 0);
            }
            if (this.ccbsBusy) {
                asnOs.writeNull(2, 1);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=" + this.extensionContainer.toString());
        }
        if (this.ccbsPossible) {
            sb.append(", ccbsPossible");
        }
        if (this.ccbsBusy) {
            sb.append(", ccbsBusy");
        }
        sb.append("]");
        return sb.toString();
    }
}

