/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.errors;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.errors.AbsentSubscriberReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriber;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class MAPErrorMessageAbsentSubscriberImpl
extends MAPErrorMessageImpl
implements MAPErrorMessageAbsentSubscriber {
    private static final String MWD_SET = "mwdSet";
    private static final String ABSENT_SUBSCRIBER_REASON = "absentSubscriberReason";
    private static final String MAP_EXTENSION_CONTAINER = "mapExtensionContainer";
    public static final int AbsentSubscriberReason_TAG = 0;
    private MAPExtensionContainer extensionContainer;
    private AbsentSubscriberReason absentSubscriberReason;
    private Boolean mwdSet;
    protected static final XMLFormat<MAPErrorMessageAbsentSubscriberImpl> MAP_ERROR_MESSAGE_ABSENT_SUBSCRIBER_XML = new XMLFormat<MAPErrorMessageAbsentSubscriberImpl>(MAPErrorMessageAbsentSubscriberImpl.class){

        public void read(XMLFormat.InputElement xml, MAPErrorMessageAbsentSubscriberImpl errorMessage) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
            errorMessage.mwdSet = (Boolean)xml.get(MAPErrorMessageAbsentSubscriberImpl.MWD_SET, Boolean.class);
            String str = (String)xml.get(MAPErrorMessageAbsentSubscriberImpl.ABSENT_SUBSCRIBER_REASON, String.class);
            if (str != null) {
                errorMessage.absentSubscriberReason = Enum.valueOf(AbsentSubscriberReason.class, str);
            }
            errorMessage.extensionContainer = (MAPExtensionContainer)xml.get(MAPErrorMessageAbsentSubscriberImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }

        public void write(MAPErrorMessageAbsentSubscriberImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            MAPErrorMessageImpl.MAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
            xml.add((Object)errorMessage.getMwdSet(), MAPErrorMessageAbsentSubscriberImpl.MWD_SET, Boolean.class);
            if (errorMessage.getAbsentSubscriberReason() != null) {
                xml.add((Object)errorMessage.getAbsentSubscriberReason().toString(), MAPErrorMessageAbsentSubscriberImpl.ABSENT_SUBSCRIBER_REASON, String.class);
            }
            xml.add((Object)((MAPExtensionContainerImpl)errorMessage.extensionContainer), MAPErrorMessageAbsentSubscriberImpl.MAP_EXTENSION_CONTAINER, MAPExtensionContainerImpl.class);
        }
    };

    public MAPErrorMessageAbsentSubscriberImpl(MAPExtensionContainer extensionContainer, AbsentSubscriberReason absentSubscriberReason) {
        super(27L);
        this.extensionContainer = extensionContainer;
        this.absentSubscriberReason = absentSubscriberReason;
    }

    public MAPErrorMessageAbsentSubscriberImpl(Boolean mwdSet) {
        super(27L);
        this.mwdSet = mwdSet;
    }

    public MAPErrorMessageAbsentSubscriberImpl() {
        super(27L);
    }

    @Override
    public boolean isEmAbsentSubscriber() {
        return true;
    }

    @Override
    public MAPErrorMessageAbsentSubscriber getEmAbsentSubscriber() {
        return this;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public AbsentSubscriberReason getAbsentSubscriberReason() {
        return this.absentSubscriberReason;
    }

    public void setExtensionContainer(MAPExtensionContainer extensionContainer) {
        this.extensionContainer = extensionContainer;
    }

    public void setAbsentSubscriberReason(AbsentSubscriberReason absentSubscriberReason) {
        this.absentSubscriberReason = absentSubscriberReason;
    }

    public Boolean getMwdSet() {
        return this.mwdSet;
    }

    public void setMwdSet(Boolean val) {
        this.mwdSet = val;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.mwdSet != null) {
            return 1;
        }
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return this.mwdSet != null;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream localAis, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.extensionContainer = null;
        this.absentSubscriberReason = null;
        this.mwdSet = null;
        switch (localAis.getTag()) {
            case 16: {
                if (localAis.getTagClass() != 0 || localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriber: bad tag class or parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                AsnInputStream ais = localAis.readSequenceStreamData(length);
                while (ais.available() != 0) {
                    int tag = ais.readTag();
                    block4 : switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 16: {
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break block4;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        case 2: {
                            switch (tag) {
                                case 0: {
                                    int code = (int)ais.readInteger();
                                    this.absentSubscriberReason = AbsentSubscriberReason.getInstance((int)code);
                                    break block4;
                                }
                            }
                            ais.advanceElement();
                            break;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
                break;
            }
            case 1: {
                if (localAis.getTagClass() != 0 || !localAis.isTagPrimitive()) {
                    throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriber: bad tag class or parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.mwdSet = localAis.readBooleanData(length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error decoding MAPErrorMessageAbsentSubscriber: bad tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws MAPException {
        if (this.mwdSet != null) {
            try {
                aos.writeBooleanData(this.mwdSet.booleanValue());
            }
            catch (IOException e) {
                throw new MAPException("IOException when encoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.absentSubscriberReason == null && this.extensionContainer == null) {
            return;
        }
        try {
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(aos);
            }
            if (this.absentSubscriberReason != null) {
                aos.writeInteger(2, 0, (long)this.absentSubscriberReason.getCode());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding MAPErrorMessageAbsentSubscriber: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MAPErrorMessageAbsentSubscriber [");
        if (this.mwdSet != null) {
            sb.append("mwdSet=" + this.mwdSet.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=" + this.extensionContainer.toString());
        }
        if (this.absentSubscriberReason != null) {
            sb.append(", absentSubscriberReason=" + this.absentSubscriberReason.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

