/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPServiceBase;
import org.mobicents.protocols.ss7.map.api.MAPServiceListener;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;

public abstract class MAPServiceBaseImpl
implements MAPServiceBase {
    protected Boolean _isActivated = false;
    protected List<MAPServiceListener> serviceListeners = new CopyOnWriteArrayList<MAPServiceListener>();
    protected MAPProviderImpl mapProviderImpl = null;

    protected MAPServiceBaseImpl(MAPProviderImpl mapProviderImpl) {
        this.mapProviderImpl = mapProviderImpl;
    }

    public MAPProvider getMAPProvider() {
        return this.mapProviderImpl;
    }

    protected abstract MAPDialogImpl createNewDialogIncoming(MAPApplicationContext var1, Dialog var2);

    protected Dialog createNewTCAPDialog(SccpAddress origAddress, SccpAddress destAddress, Long localTrId) throws MAPException {
        try {
            return this.mapProviderImpl.getTCAPProvider().getNewDialog(origAddress, destAddress, localTrId);
        }
        catch (TCAPException e) {
            throw new MAPException(e.getMessage(), (Throwable)e);
        }
    }

    public abstract void processComponent(ComponentType var1, OperationCode var2, Parameter var3, MAPDialog var4, Long var5, Long var6, Invoke var7) throws MAPParsingComponentException;

    protected void putMAPDialogIntoCollection(MAPDialogImpl dialog) {
        this.mapProviderImpl.addDialog(dialog);
    }

    protected void addMAPServiceListener(MAPServiceListener mapServiceListener) {
        this.serviceListeners.add(mapServiceListener);
    }

    protected void removeMAPServiceListener(MAPServiceListener mapServiceListener) {
        this.serviceListeners.remove(mapServiceListener);
    }

    public MAPApplicationContext getMAPv1ApplicationContext(int operationCode, Invoke invoke) {
        return null;
    }

    public long[] getLinkedOperationList(long operCode) {
        return null;
    }

    public boolean checkInvokeTimeOut(MAPDialog dialog, Invoke invoke) {
        return false;
    }

    public boolean isActivated() {
        return this._isActivated;
    }

    public void acivate() {
        this._isActivated = true;
    }

    public void deactivate() {
        this._isActivated = false;
    }

    protected void deliverErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onErrorComponent(mapDialog, invokeId, mapErrorMessage);
        }
    }

    protected void deliverRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem, boolean isLocalOriginated) {
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onRejectComponent(mapDialog, invokeId, problem, isLocalOriginated);
        }
    }

    protected void deliverInvokeTimeout(MAPDialog mapDialog, Invoke invoke) {
        for (MAPServiceListener serLis : this.serviceListeners) {
            serLis.onInvokeTimeout(mapDialog, invoke.getInvokeId());
        }
    }
}

