/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.api.datacoding;

public enum CBSNationalLanguage {
    German(0),
    English(1),
    Italian(2),
    French(3),
    Spanish(4),
    Dutch(5),
    Swedish(6),
    Danish(7),
    Portuguese(8),
    Finnish(9),
    Norwegian(10),
    Greek(11),
    Turkish(12),
    Hungarian(13),
    Polish(14),
    LanguageUnspecified(15),
    Czech(32),
    Hebrew(33),
    Arabic(34),
    Russian(35),
    Icelandic(36);

    private int code;

    private CBSNationalLanguage(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public int getCBSCodingGroupBits() {
        return (this.code & 0xF0) >> 4;
    }

    public int getCBSLowBits() {
        return this.code & 0xF;
    }

    public static CBSNationalLanguage getInstance(int codingGroupBits, int lowBits) {
        if (codingGroupBits == 0) {
            switch (lowBits) {
                case 0: {
                    return German;
                }
                case 1: {
                    return English;
                }
                case 2: {
                    return Italian;
                }
                case 3: {
                    return French;
                }
                case 4: {
                    return Spanish;
                }
                case 5: {
                    return Dutch;
                }
                case 6: {
                    return Swedish;
                }
                case 7: {
                    return Danish;
                }
                case 8: {
                    return Portuguese;
                }
                case 9: {
                    return Finnish;
                }
                case 10: {
                    return Norwegian;
                }
                case 11: {
                    return Greek;
                }
                case 12: {
                    return Turkish;
                }
                case 13: {
                    return Hungarian;
                }
                case 14: {
                    return Polish;
                }
            }
            return LanguageUnspecified;
        }
        if (codingGroupBits == 2) {
            switch (lowBits) {
                case 0: {
                    return Czech;
                }
                case 1: {
                    return Hebrew;
                }
                case 2: {
                    return Arabic;
                }
                case 3: {
                    return Russian;
                }
                case 4: {
                    return Icelandic;
                }
            }
            return LanguageUnspecified;
        }
        return LanguageUnspecified;
    }
}

