/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.sms.EventReportSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.EventSpecificInformationSMS;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.EventTypeSMS;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.EventSpecificInformationSMSImpl;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.primitives.MiscCallInfo;
import org.mobicents.protocols.ss7.inap.primitives.MiscCallInfoImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class EventReportSMSRequestImpl
extends SmsMessageImpl
implements EventReportSMSRequest {
    public static final String _PrimitiveName = "EventReportSMSRequest";
    public static final int _ID_eventTypeSMS = 0;
    public static final int _ID_eventSpecificInformationSMS = 1;
    public static final int _ID_miscCallInfo = 2;
    public static final int _ID_extensions = 10;
    private EventTypeSMS eventTypeSMS;
    private EventSpecificInformationSMS eventSpecificInformationSMS;
    private MiscCallInfo miscCallInfo;
    private CAPExtensions extensions;

    public EventReportSMSRequestImpl(EventTypeSMS eventTypeSMS, EventSpecificInformationSMS eventSpecificInformationSMS, MiscCallInfo miscCallInfo, CAPExtensions extensions) {
        this.eventTypeSMS = eventTypeSMS;
        this.eventSpecificInformationSMS = eventSpecificInformationSMS;
        this.miscCallInfo = miscCallInfo;
        this.extensions = extensions;
    }

    public EventReportSMSRequestImpl() {
    }

    public EventTypeSMS getEventTypeSMS() {
        return this.eventTypeSMS;
    }

    public EventSpecificInformationSMS getEventSpecificInformationSMS() {
        return this.eventSpecificInformationSMS;
    }

    public MiscCallInfo getMiscCallInfo() {
        return this.miscCallInfo;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.eventReportSMS_Request;
    }

    public int getOperationCode() {
        return 64;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException, INAPParsingComponentException {
        this.eventTypeSMS = null;
        this.eventSpecificInformationSMS = null;
        this.miscCallInfo = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest.eventTypeSMS: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.eventTypeSMS = EventTypeSMS.getInstance((int)i1);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest.eventSpecificInformationSMS: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.eventSpecificInformationSMS = new EventSpecificInformationSMSImpl();
                        AsnInputStream ais3 = ais.readSequenceStream();
                        ais3.readTag();
                        ((EventSpecificInformationSMSImpl)this.eventSpecificInformationSMS).decodeAll(ais3);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest.miscCallInfo: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.miscCallInfo = new MiscCallInfoImpl();
                        ((MiscCallInfoImpl)this.miscCallInfo).decodeAll(ais);
                        break;
                    }
                    case 10: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest.extensions: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.eventTypeSMS == null) {
            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest: eventTypeSMS parameter mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.eventTypeSMS == null) {
            throw new CAPException("Error while encoding EventReportSMSRequest: eventTypeSMS must not be null");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.eventTypeSMS.getCode());
            if (this.eventSpecificInformationSMS != null) {
                try {
                    asnOs.writeTag(2, false, 1);
                    int pos = asnOs.StartContentDefiniteLength();
                    ((EventSpecificInformationSMSImpl)this.eventSpecificInformationSMS).encodeAll(asnOs);
                    asnOs.FinalizeContent(pos);
                }
                catch (AsnException e) {
                    throw new CAPException("AsnException while encoding EventReportSMSRequest parameter subscribedQoS");
                }
            }
            if (this.miscCallInfo != null) {
                ((MiscCallInfoImpl)this.miscCallInfo).encodeAll(asnOs, 2, 2);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(asnOs, 2, 10);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding EventReportSMSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.eventTypeSMS != null) {
            sb.append(", eventTypeSMS=");
            sb.append(this.eventTypeSMS.toString());
        }
        if (this.eventSpecificInformationSMS != null) {
            sb.append(", eventSpecificInformationSMS=");
            sb.append(this.eventSpecificInformationSMS.toString());
        }
        if (this.miscCallInfo != null) {
            sb.append(", miscCallInfo=");
            sb.append(this.miscCallInfo.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

