/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ChargingCharacteristics;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ChargingCharacteristicsImpl
implements ChargingCharacteristics,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "ChargingCharacteristics";
    public static final int _ID_maxTransferredVolume = 0;
    public static final int _ID_maxElapsedTime = 1;
    private long maxTransferredVolume;
    private int maxElapsedTime;

    public ChargingCharacteristicsImpl() {
        this.maxElapsedTime = -1;
        this.maxTransferredVolume = -1L;
    }

    public ChargingCharacteristicsImpl(long maxTransferredVolume) {
        this.maxTransferredVolume = maxTransferredVolume;
        this.maxElapsedTime = -1;
    }

    public ChargingCharacteristicsImpl(int maxElapsedTime) {
        this.maxElapsedTime = maxElapsedTime;
        this.maxTransferredVolume = -1L;
    }

    public long getMaxTransferredVolume() {
        return this.maxTransferredVolume;
    }

    public int getMaxElapsedTime() {
        return this.maxElapsedTime;
    }

    @Override
    public int getTag() throws CAPException {
        if (this.maxTransferredVolume != -1L) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        block7: {
            block6: {
                this.maxTransferredVolume = -1L;
                this.maxElapsedTime = -1;
                int tag = ais.getTag();
                if (ais.getTagClass() != 2) break block6;
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ChargingCharacteristics.maxTransferredVolume: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.maxTransferredVolume = ais.readIntegerData(length);
                        break block7;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ChargingCharacteristics.maxElapsedTime: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.maxElapsedTime = (int)ais.readIntegerData(length);
                        break block7;
                    }
                    default: {
                        throw new CAPParsingComponentException("Error while decoding ChargingCharacteristics: bad choice tag", CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
            }
            throw new CAPParsingComponentException("Error while decoding ChargingCharacteristics: bad choice tagClass", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.maxTransferredVolume == -1L && this.maxElapsedTime == -1 || this.maxTransferredVolume != -1L && this.maxElapsedTime != -1) {
            throw new CAPException("Error while decoding ChargingCharacteristics: One and only one choice must be selected");
        }
        try {
            if (this.maxTransferredVolume != -1L) {
                asnOs.writeIntegerData(this.maxTransferredVolume);
            } else {
                asnOs.writeIntegerData((long)this.maxElapsedTime);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ChargingCharacteristics: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChargingCharacteristics [");
        if (this.maxTransferredVolume != -1L) {
            sb.append("maxTransferredVolume=");
            sb.append(this.maxTransferredVolume);
        }
        if (this.maxElapsedTime != -1) {
            sb.append("maxElapsedTime=");
            sb.append(this.maxElapsedTime);
        }
        sb.append("]");
        return sb.toString();
    }
}

