/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.MidCallControlInfo;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class MidCallControlInfoImpl
extends SequenceBase
implements MidCallControlInfo {
    private static final String MINIMUM_NUMBER_OF_DIGITS = "minimumNumberOfDigits";
    private static final String MAXIMUM_NUMBER_OF_DIGITS = "maximumNumberOfDigits";
    private static final String END_OF_REPLY_DIGIT = "endOfReplyDigit";
    private static final String CANCEL_DIGIT = "cancelDigit";
    private static final String START_DIGIT = "startDigit";
    private static final String INTER_DIGIT_TIMEOUT = "interDigitTimeout";
    public static final int _ID_minimumNumberOfDigits = 0;
    public static final int _ID_maximumNumberOfDigits = 1;
    public static final int _ID_endOfReplyDigit = 2;
    public static final int _ID_cancelDigit = 3;
    public static final int _ID_startDigit = 4;
    public static final int _ID_interDigitTimeout = 6;
    private Integer minimumNumberOfDigits;
    private Integer maximumNumberOfDigits;
    private String endOfReplyDigit;
    private String cancelDigit;
    private String startDigit;
    private Integer interDigitTimeout;
    protected static final XMLFormat<MidCallControlInfoImpl> MID_CALL_CONTROL_INFO_XML = new XMLFormat<MidCallControlInfoImpl>(MidCallControlInfoImpl.class){

        public void read(XMLFormat.InputElement xml, MidCallControlInfoImpl midCallControlInfo) throws XMLStreamException {
            midCallControlInfo.minimumNumberOfDigits = (Integer)xml.get(MidCallControlInfoImpl.MINIMUM_NUMBER_OF_DIGITS, Integer.class);
            midCallControlInfo.maximumNumberOfDigits = (Integer)xml.get(MidCallControlInfoImpl.MAXIMUM_NUMBER_OF_DIGITS, Integer.class);
            midCallControlInfo.endOfReplyDigit = (String)xml.get(MidCallControlInfoImpl.END_OF_REPLY_DIGIT, String.class);
            midCallControlInfo.cancelDigit = (String)xml.get(MidCallControlInfoImpl.CANCEL_DIGIT, String.class);
            midCallControlInfo.startDigit = (String)xml.get(MidCallControlInfoImpl.START_DIGIT, String.class);
            midCallControlInfo.interDigitTimeout = (Integer)xml.get(MidCallControlInfoImpl.INTER_DIGIT_TIMEOUT, Integer.class);
        }

        public void write(MidCallControlInfoImpl midCallControlInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (midCallControlInfo.minimumNumberOfDigits != null) {
                xml.add((Object)midCallControlInfo.minimumNumberOfDigits, MidCallControlInfoImpl.MINIMUM_NUMBER_OF_DIGITS, Integer.class);
            }
            if (midCallControlInfo.maximumNumberOfDigits != null) {
                xml.add((Object)midCallControlInfo.maximumNumberOfDigits, MidCallControlInfoImpl.MAXIMUM_NUMBER_OF_DIGITS, Integer.class);
            }
            if (midCallControlInfo.endOfReplyDigit != null) {
                xml.add((Object)midCallControlInfo.endOfReplyDigit, MidCallControlInfoImpl.END_OF_REPLY_DIGIT, String.class);
            }
            if (midCallControlInfo.cancelDigit != null) {
                xml.add((Object)midCallControlInfo.cancelDigit, MidCallControlInfoImpl.CANCEL_DIGIT, String.class);
            }
            if (midCallControlInfo.startDigit != null) {
                xml.add((Object)midCallControlInfo.startDigit, MidCallControlInfoImpl.START_DIGIT, String.class);
            }
            if (midCallControlInfo.interDigitTimeout != null) {
                xml.add((Object)midCallControlInfo.interDigitTimeout, MidCallControlInfoImpl.INTER_DIGIT_TIMEOUT, Integer.class);
            }
        }
    };

    public MidCallControlInfoImpl() {
        super("MidCallControlInfo");
    }

    public MidCallControlInfoImpl(Integer minimumNumberOfDigits, Integer maximumNumberOfDigits, String endOfReplyDigit, String cancelDigit, String startDigit, Integer interDigitTimeout) {
        super("MidCallControlInfo");
        this.minimumNumberOfDigits = minimumNumberOfDigits;
        this.maximumNumberOfDigits = maximumNumberOfDigits;
        this.endOfReplyDigit = endOfReplyDigit;
        this.cancelDigit = cancelDigit;
        this.startDigit = startDigit;
        this.interDigitTimeout = interDigitTimeout;
    }

    public Integer getMinimumNumberOfDigits() {
        return this.minimumNumberOfDigits;
    }

    public Integer getMaximumNumberOfDigits() {
        return this.maximumNumberOfDigits;
    }

    public String getEndOfReplyDigit() {
        return this.endOfReplyDigit;
    }

    public String getCancelDigit() {
        return this.cancelDigit;
    }

    public String getStartDigit() {
        return this.startDigit;
    }

    public Integer getInterDigitTimeout() {
        return this.interDigitTimeout;
    }

    protected int encodeNumber(char c, String parameterName) throws CAPException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '#': {
                return 11;
            }
        }
        throw new CAPException(this._PrimitiveName + ": Error when encoding parameter " + parameterName + ": as a value must be digits 1-9, * and #, found char: " + c);
    }

    protected char decodeNumber(int i, String parameterName) throws CAPParsingComponentException {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
        }
        throw new CAPParsingComponentException(this._PrimitiveName + ": Error when decoding parameter " + parameterName + ": as a value must be digits 1-9, * and #, found code: " + i, CAPParsingComponentExceptionReason.MistypedParameter);
    }

    private String readStringData(AsnInputStream ais, String parameterName) throws CAPParsingComponentException {
        try {
            byte[] val = ais.readOctetString();
            if (val.length < 1 || val.length > 2) {
                throw new CAPParsingComponentException(this._PrimitiveName + ": Error when decoding parameter " + parameterName + ": octet string must have length 1-2 bytes, found: " + val.length, CAPParsingComponentExceptionReason.MistypedParameter);
            }
            StringBuilder sb = new StringBuilder();
            for (byte b : val) {
                char ch = this.decodeNumber(b, parameterName);
                sb.append(ch);
            }
            return sb.toString();
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException(this._PrimitiveName + ": AsnException when decoding parameter " + parameterName, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException(this._PrimitiveName + ": IOException when decoding parameter " + parameterName, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void writeStringData(AsnOutputStream aos, int tag, String value, String parameterName) throws CAPException {
        if (value.length() < 1 || value.length() > 2) {
            throw new CAPException(this._PrimitiveName + ": Error when encoding parameter " + parameterName + ": string must have length 1-2 chars, found: " + value.length());
        }
        byte[] val = new byte[value.length()];
        for (int i1 = 0; i1 < value.length(); ++i1) {
            val[i1] = (byte)this.encodeNumber(value.charAt(i1), parameterName);
        }
        try {
            aos.writeOctetString(2, tag, val);
        }
        catch (IOException e) {
            throw new CAPException(this._PrimitiveName + ": IOException when encoding parameter " + parameterName);
        }
        catch (AsnException e) {
            throw new CAPException(this._PrimitiveName + ": AsnException when encoding parameter " + parameterName);
        }
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException, INAPParsingComponentException {
        this.minimumNumberOfDigits = null;
        this.maximumNumberOfDigits = null;
        this.endOfReplyDigit = null;
        this.cancelDigit = null;
        this.startDigit = null;
        this.interDigitTimeout = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block8: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.minimumNumberOfDigits = (int)ais.readInteger();
                        continue block8;
                    }
                    case 1: {
                        this.maximumNumberOfDigits = (int)ais.readInteger();
                        continue block8;
                    }
                    case 2: {
                        this.endOfReplyDigit = this.readStringData(ais, END_OF_REPLY_DIGIT);
                        continue block8;
                    }
                    case 3: {
                        this.cancelDigit = this.readStringData(ais, CANCEL_DIGIT);
                        continue block8;
                    }
                    case 4: {
                        this.startDigit = this.readStringData(ais, START_DIGIT);
                        continue block8;
                    }
                    case 6: {
                        this.interDigitTimeout = (int)ais.readInteger();
                        continue block8;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            if (this.minimumNumberOfDigits != null) {
                if (this.minimumNumberOfDigits < 1 || this.minimumNumberOfDigits > 30) {
                    throw new CAPException("IOException when encoding " + this._PrimitiveName + ": minimumNumberOfDigits must be from 1 to 30, it is=" + this.minimumNumberOfDigits);
                }
                aos.writeInteger(2, 0, (long)this.minimumNumberOfDigits.intValue());
            }
            if (this.maximumNumberOfDigits != null) {
                if (this.maximumNumberOfDigits < 1 || this.maximumNumberOfDigits > 30) {
                    throw new CAPException("IOException when encoding " + this._PrimitiveName + ": maximumNumberOfDigits must be from 1 to 30, it is=" + this.maximumNumberOfDigits);
                }
                aos.writeInteger(2, 1, (long)this.maximumNumberOfDigits.intValue());
            }
            if (this.endOfReplyDigit != null) {
                this.writeStringData(aos, 2, this.endOfReplyDigit, END_OF_REPLY_DIGIT);
            }
            if (this.cancelDigit != null) {
                this.writeStringData(aos, 3, this.cancelDigit, CANCEL_DIGIT);
            }
            if (this.startDigit != null) {
                this.writeStringData(aos, 4, this.startDigit, START_DIGIT);
            }
            if (this.interDigitTimeout != null) {
                if (this.interDigitTimeout < 1 || this.interDigitTimeout > 127) {
                    throw new CAPException("IOException when encoding " + this._PrimitiveName + ": interDigitTimeout must be from 1 to 127, it is=" + this.interDigitTimeout);
                }
                aos.writeInteger(2, 6, (long)this.interDigitTimeout.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.minimumNumberOfDigits != null) {
            sb.append("minimumNumberOfDigits=");
            sb.append(this.minimumNumberOfDigits);
            sb.append(", ");
        }
        if (this.maximumNumberOfDigits != null) {
            sb.append("maximumNumberOfDigits=");
            sb.append(this.maximumNumberOfDigits);
            sb.append(", ");
        }
        if (this.endOfReplyDigit != null) {
            sb.append("endOfReplyDigit=\"");
            sb.append(this.endOfReplyDigit);
            sb.append("\", ");
        }
        if (this.cancelDigit != null) {
            sb.append("cancelDigit=\"");
            sb.append(this.cancelDigit);
            sb.append("\", ");
        }
        if (this.startDigit != null) {
            sb.append("startDigit=\"");
            sb.append(this.startDigit);
            sb.append("\", ");
        }
        if (this.interDigitTimeout != null) {
            sb.append("interDigitTimeout=");
            sb.append(this.interDigitTimeout);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

