/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.SplitLegRequest;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.primitives.LegID;
import org.mobicents.protocols.ss7.inap.primitives.LegIDImpl;

public class SplitLegRequestImpl
extends CircuitSwitchedCallMessageImpl
implements SplitLegRequest {
    private static final long serialVersionUID = 1L;
    public static final int _ID_legToBeSplit = 0;
    public static final int _ID_newCallSegment = 1;
    public static final int _ID_extensions = 2;
    private static final String LEG_TO_BE_SPLIT = "legToBeSplit";
    private static final String NEW_CALL_SEGMENT = "newCallSegment";
    private static final String EXTENSIONS = "extensions";
    public static final String _PrimitiveName = "SplitLegRequest";
    private LegID legToBeSplit;
    private Integer newCallSegment;
    private CAPExtensions extensions;
    protected static final XMLFormat<SplitLegRequestImpl> SPLIT_LEG_XML = new XMLFormat<SplitLegRequestImpl>(SplitLegRequestImpl.class){

        public void read(XMLFormat.InputElement xml, SplitLegRequestImpl splitLegRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)splitLegRequest);
            splitLegRequest.legToBeSplit = (LegID)xml.get(SplitLegRequestImpl.LEG_TO_BE_SPLIT, LegIDImpl.class);
            if (splitLegRequest.legToBeSplit == null) {
                throw new XMLStreamException("Error while decoding SplitLegRequest: legToBeSplit is mandatory but not found ");
            }
            splitLegRequest.newCallSegment = (Integer)xml.get(SplitLegRequestImpl.NEW_CALL_SEGMENT, Integer.class);
            splitLegRequest.extensions = (CAPExtensions)xml.get(SplitLegRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
        }

        public void write(SplitLegRequestImpl splitLegRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)splitLegRequest, xml);
            xml.add((Object)((LegIDImpl)splitLegRequest.getLegToBeSplit()), SplitLegRequestImpl.LEG_TO_BE_SPLIT, LegIDImpl.class);
            xml.add((Object)splitLegRequest.newCallSegment, SplitLegRequestImpl.NEW_CALL_SEGMENT, Integer.class);
            xml.add((Object)((CAPExtensionsImpl)splitLegRequest.getExtensions()), SplitLegRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
        }
    };

    public SplitLegRequestImpl() {
    }

    public SplitLegRequestImpl(LegID legIDToMove, Integer newCallSegment, CAPExtensions extensions) {
        this.legToBeSplit = legIDToMove;
        this.newCallSegment = newCallSegment;
        this.extensions = extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.splitLeg_Request;
    }

    public int getOperationCode() {
        return 95;
    }

    public LegID getLegToBeSplit() {
        return this.legToBeSplit;
    }

    public Integer getNewCallSegment() {
        return this.newCallSegment;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (Exception e) {
            throw new CAPParsingComponentException(e.getClass().getSimpleName() + " when decoding " + _PrimitiveName + ": " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (Exception e) {
            throw new CAPParsingComponentException(e.getClass().getSimpleName() + " when decoding " + _PrimitiveName + ": " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, INAPParsingComponentException, IOException, AsnException {
        this.legToBeSplit = null;
        this.newCallSegment = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block5: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.legToBeSplit = new LegIDImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((LegIDImpl)this.legToBeSplit).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        this.newCallSegment = (int)ais.readInteger();
                        if (this.newCallSegment >= 1 && this.newCallSegment <= 127) continue block5;
                        throw new CAPParsingComponentException("Error while decoding SplitLegRequest: newCallSegment value must be 1..127, found: " + this.newCallSegment, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.legToBeSplit == null) {
            throw new CAPParsingComponentException("Error while decoding SplitLegRequest: legToBeSplit is mandatory but not found ", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding SplitLegRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.legToBeSplit == null) {
            throw new CAPException("Error while encoding SplitLegRequest: legToBeSplit must not be null");
        }
        try {
            aos.writeTag(2, this.getIsPrimitive(), 0);
            int pos = aos.StartContentDefiniteLength();
            ((LegIDImpl)this.legToBeSplit).encodeAll(aos);
            aos.FinalizeContent(pos);
            if (this.newCallSegment != null) {
                if (this.newCallSegment < 1 || this.newCallSegment > 127) {
                    throw new CAPException("Error while encoding SplitLegRequest: newCallSegment value must be 1..127, found: " + this.newCallSegment);
                }
                aos.writeInteger(2, 1, (long)this.newCallSegment.intValue());
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
        }
        catch (Exception e) {
            throw new CAPException(e.getClass().getSimpleName() + " when encoding " + _PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.legToBeSplit != null) {
            sb.append("legToBeSplit=");
            sb.append(this.legToBeSplit.toString());
        }
        if (this.newCallSegment != null) {
            sb.append(", newCallSegment=");
            sb.append(this.newCallSegment.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

