/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.GapCriteria;
import org.mobicents.protocols.ss7.cap.api.gap.GapIndicators;
import org.mobicents.protocols.ss7.cap.api.gap.GapTreatment;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallGapRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.ControlType;
import org.mobicents.protocols.ss7.cap.gap.GapCriteriaImpl;
import org.mobicents.protocols.ss7.cap.gap.GapIndicatorsImpl;
import org.mobicents.protocols.ss7.cap.gap.GapTreatmentImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;

public class CallGapRequestImpl
extends CircuitSwitchedCallMessageImpl
implements CallGapRequest {
    public static final int _ID_gapCriteria = 0;
    public static final int _ID_gapIndicators = 1;
    public static final int _ID_controlType = 2;
    public static final int _ID_gapTreatment = 3;
    public static final int _ID_capExtension = 4;
    private static final String IS_CAP_VERSION_3_OR_LATER = "isCAPVersion3orLater";
    public static final String _PrimitiveName = "CallGapRequestIndication";
    private static final String GAP_CRITERIA = "gapCriteria";
    private static final String GAP_INDICATOR = "gapIndicators";
    private static final String CONTROL_TYPE = "controlType";
    private static final String GAP_TREATMENT = "gapTreatment";
    private static final String CAP_EXTENSION = "capExtension";
    private GapCriteria gapCriteria;
    private GapIndicators gapIndicators;
    private ControlType controlType;
    private GapTreatment gapTreatment;
    private CAPExtensions capExtensions;
    private boolean isCAPVersion3orLater;
    protected static final XMLFormat<CallGapRequestImpl> CALLGAP_REQUEST_XML = new XMLFormat<CallGapRequestImpl>(CallGapRequestImpl.class){

        public void read(XMLFormat.InputElement xml, CallGapRequestImpl callGapRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)callGapRequest);
            callGapRequest.isCAPVersion3orLater = xml.getAttribute(CallGapRequestImpl.IS_CAP_VERSION_3_OR_LATER, false);
            callGapRequest.gapCriteria = (GapCriteria)xml.get(CallGapRequestImpl.GAP_CRITERIA, GapCriteriaImpl.class);
            callGapRequest.gapIndicators = (GapIndicators)xml.get(CallGapRequestImpl.GAP_INDICATOR, GapIndicatorsImpl.class);
            String str = (String)xml.get(CallGapRequestImpl.CONTROL_TYPE, String.class);
            if (str != null) {
                callGapRequest.controlType = Enum.valueOf(ControlType.class, str);
            }
            callGapRequest.gapTreatment = (GapTreatment)xml.get(CallGapRequestImpl.GAP_TREATMENT, GapTreatmentImpl.class);
            callGapRequest.capExtensions = (CAPExtensions)xml.get(CallGapRequestImpl.CAP_EXTENSION, CAPExtensionsImpl.class);
        }

        public void write(CallGapRequestImpl callGapRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)callGapRequest, xml);
            xml.setAttribute(CallGapRequestImpl.IS_CAP_VERSION_3_OR_LATER, callGapRequest.isCAPVersion3orLater);
            xml.add((Object)((GapCriteriaImpl)callGapRequest.getGapCriteria()), CallGapRequestImpl.GAP_CRITERIA, GapCriteriaImpl.class);
            xml.add((Object)((GapIndicatorsImpl)callGapRequest.getGapIndicators()), CallGapRequestImpl.GAP_INDICATOR, GapIndicatorsImpl.class);
            if (callGapRequest.getControlType() != null) {
                xml.add((Object)callGapRequest.getControlType().toString(), CallGapRequestImpl.CONTROL_TYPE, String.class);
            }
            if (callGapRequest.getGapTreatment() != null) {
                xml.add((Object)((GapTreatmentImpl)callGapRequest.getGapTreatment()), CallGapRequestImpl.GAP_TREATMENT, GapTreatmentImpl.class);
            }
            if (callGapRequest.getExtensions() != null) {
                xml.add((Object)((CAPExtensionsImpl)callGapRequest.getExtensions()), CallGapRequestImpl.CAP_EXTENSION, CAPExtensionsImpl.class);
            }
        }
    };

    public CallGapRequestImpl() {
    }

    public CallGapRequestImpl(boolean isCAPVersion3orLater) {
        this.isCAPVersion3orLater = isCAPVersion3orLater;
    }

    public CallGapRequestImpl(GapCriteria gapCriteria, GapIndicators gapIndicators, ControlType controlType, GapTreatment gapTreatment, CAPExtensions capExtension) {
        this.gapCriteria = gapCriteria;
        this.gapIndicators = gapIndicators;
        this.controlType = controlType;
        this.gapTreatment = gapTreatment;
        this.capExtensions = capExtension;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.callGap_Request;
    }

    public int getOperationCode() {
        return 41;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallGapRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallGapRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallGapRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallGapRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.gapCriteria = null;
        this.gapIndicators = null;
        this.controlType = null;
        this.gapTreatment = null;
        this.capExtensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.gapCriteria = new GapCriteriaImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((GapCriteriaImpl)this.gapCriteria).decodeAll(ais2);
                        continue block7;
                    }
                    case 1: {
                        this.gapIndicators = new GapIndicatorsImpl();
                        ((GapIndicatorsImpl)this.gapIndicators).decodeAll(ais);
                        continue block7;
                    }
                    case 2: {
                        int i1 = (int)ais.readInteger();
                        this.controlType = ControlType.getInstance((int)i1);
                        continue block7;
                    }
                    case 3: {
                        this.gapTreatment = new GapTreatmentImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((GapTreatmentImpl)this.gapTreatment).decodeAll(ais2);
                        continue block7;
                    }
                    case 4: {
                        this.capExtensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.capExtensions).decodeAll(ais);
                        continue block7;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.gapCriteria == null) {
            throw new CAPParsingComponentException("Error while decoding CallGapRequestIndication: parameter gapCriteria is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.gapIndicators == null) {
            throw new CAPParsingComponentException("Error while decoding CallGapRequestIndication: parameter gapIndicators is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CallGapRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.gapCriteria == null) {
            throw new CAPException("Error while encoding CallGapRequestIndication: gapCriteria must not be null");
        }
        if (this.gapIndicators == null) {
            throw new CAPException("Error while encoding CallGapRequestIndication: gapIndicators must not be null");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((GapCriteriaImpl)this.gapCriteria).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
            ((GapIndicatorsImpl)this.gapIndicators).encodeAll(asnOs, 2, 1);
            if (this.controlType != null) {
                asnOs.writeInteger(2, 2, (long)this.controlType.getCode());
            }
            if (this.gapTreatment != null) {
                asnOs.writeTag(2, false, 3);
                int pos2 = asnOs.StartContentDefiniteLength();
                ((GapTreatmentImpl)this.gapTreatment).encodeAll(asnOs);
                asnOs.FinalizeContent(pos2);
            }
            if (this.capExtensions != null) {
                ((CAPExtensionsImpl)this.capExtensions).encodeAll(asnOs, 2, 4);
            }
        }
        catch (IOException ex) {
            throw new CAPException("IOException when encoding CallGapRequestIndication: " + ex.getMessage(), (Throwable)ex);
        }
        catch (AsnException ex) {
            throw new CAPException("AsnException when encoding CallGapRequestIndication: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public GapCriteria getGapCriteria() {
        return this.gapCriteria;
    }

    public GapIndicators getGapIndicators() {
        return this.gapIndicators;
    }

    public ControlType getControlType() {
        return this.controlType;
    }

    public GapTreatment getGapTreatment() {
        return this.gapTreatment;
    }

    public CAPExtensions getExtensions() {
        return this.capExtensions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        sb.append(", gapCriteria=");
        sb.append(this.gapCriteria);
        sb.append(", gapIndicators=");
        sb.append(this.gapIndicators);
        if (this.controlType != null) {
            sb.append(", controlType");
            sb.append(this.controlType.toString());
        }
        if (this.gapTreatment != null) {
            sb.append(", gapTreatment");
            sb.append(this.gapTreatment.toString());
        }
        if (this.capExtensions != null) {
            sb.append(", capExtensions");
            sb.append(this.capExtensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

