/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public abstract class TbcdString
implements CAPAsnPrimitive {
    protected static int DIGIT_1_MASK = 15;
    protected static int DIGIT_2_MASK = 240;
    protected String data;
    protected int minLength;
    protected int maxLength;
    protected String _PrimitiveName;

    public TbcdString(int minLength, int maxLength, String _PrimitiveName) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this._PrimitiveName = _PrimitiveName;
    }

    public TbcdString(int minLength, int maxLength, String _PrimitiveName, String data) {
        this(minLength, maxLength, _PrimitiveName);
        this.data = data;
    }

    @Override
    public int getTag() throws CAPException {
        return 4;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    protected void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException {
        if (!ansIS.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error decoding " + this._PrimitiveName + ": field must be primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (length < this.minLength || length > this.maxLength) {
            throw new CAPParsingComponentException("Error decoding " + this._PrimitiveName + ": the field must contain from " + this.minLength + " to " + this.maxLength + " octets. Contains: " + length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        try {
            this.data = TbcdString.decodeString((InputStream)ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding IMSI: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("Error while encoding the " + this._PrimitiveName + ": data is not defined");
        }
        TbcdString.encodeString((OutputStream)asnOs, this.data);
    }

    public static String decodeString(InputStream ansIS, int length) throws IOException, CAPParsingComponentException {
        StringBuilder s = new StringBuilder();
        for (int i1 = 0; i1 < length; ++i1) {
            int b = ansIS.read();
            int digit1 = b & DIGIT_1_MASK;
            if (digit1 != 15) {
                s.append(TbcdString.decodeNumber(digit1));
            }
            int digit2 = (b & DIGIT_2_MASK) >> 4;
            if (digit2 == 15) continue;
            s.append(TbcdString.decodeNumber(digit2));
        }
        return s.toString();
    }

    public static void encodeString(OutputStream asnOs, String data) throws CAPException {
        char[] chars = data.toCharArray();
        for (int i = 0; i < chars.length; i += 2) {
            int digit2;
            char a = chars[i];
            int digit1 = TbcdString.encodeNumber(a);
            if (i + 1 == chars.length) {
                digit2 = 15;
            } else {
                char b = chars[i + 1];
                digit2 = TbcdString.encodeNumber(b);
            }
            int digit = digit2 << 4 | digit1;
            try {
                asnOs.write(digit);
                continue;
            }
            catch (IOException e) {
                throw new CAPException("Error when encoding TbcdString: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static int encodeNumber(char c) throws CAPException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '#': {
                return 11;
            }
            case 'a': {
                return 12;
            }
            case 'b': {
                return 13;
            }
            case 'c': {
                return 14;
            }
        }
        throw new CAPException("char should be between 0 - 9, *, #, a, b, c for Telephony Binary Coded Decimal String. Received " + c);
    }

    protected static char decodeNumber(int i) throws CAPParsingComponentException {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return 'a';
            }
            case 13: {
                return 'b';
            }
            case 14: {
                return 'c';
            }
        }
        throw new CAPParsingComponentException("Integer should be between 0 - 15 for Telephony Binary Coded Decimal String. Received " + i, CAPParsingComponentExceptionReason.MistypedParameter);
    }

    public String toString() {
        return this._PrimitiveName + " [" + this.data + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TbcdString other = (TbcdString)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }
}

