/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.dsmiley.httpproxy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class ProxyServlet
extends HttpServlet {
    public static final String P_LOG = "log";
    protected boolean doLog = false;
    protected URI targetUri;
    protected HttpClient proxyClient;
    private static final HeaderGroup hopByHopHeaders;
    static final BitSet asciiQueryChars;

    public String getServletInfo() {
        return "A proxy servlet by David Smiley, dsmiley@mitre.org";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String doLogStr = servletConfig.getInitParameter(P_LOG);
        if (doLogStr != null) {
            this.doLog = Boolean.parseBoolean(doLogStr);
        }
        try {
            this.targetUri = new URI(servletConfig.getInitParameter("targetUri"));
        }
        catch (Exception e) {
            throw new RuntimeException("Trying to process targetUri init parameter: " + e, e);
        }
        BasicHttpParams hcParams = new BasicHttpParams();
        this.readConfigParam((HttpParams)hcParams, "http.protocol.handle-redirects", Boolean.class);
        this.proxyClient = this.createHttpClient((HttpParams)hcParams);
    }

    protected HttpClient createHttpClient(HttpParams hcParams) {
        return new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(), hcParams);
    }

    private void readConfigParam(HttpParams hcParams, String hcParamName, Class type) {
        Object val_obj;
        String val_str = this.getServletConfig().getInitParameter(hcParamName);
        if (val_str == null) {
            return;
        }
        if (type == String.class) {
            val_obj = val_str;
        } else {
            try {
                val_obj = type.getMethod("valueOf", String.class).invoke((Object)type, val_str);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        hcParams.setParameter(hcParamName, val_obj);
    }

    public void destroy() {
        if (this.proxyClient != null) {
            this.proxyClient.getConnectionManager().shutdown();
        }
        super.destroy();
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BasicHttpRequest proxyRequest;
        String method = servletRequest.getMethod();
        String proxyRequestUri = this.rewriteUrlFromRequest(servletRequest);
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), (long)servletRequest.getContentLength()));
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, proxyRequestUri);
        }
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest);
        try {
            int statusCode;
            HttpResponse proxyResponse;
            if (this.doLog) {
                this.log("proxy " + method + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
            }
            if (this.doResponseRedirectOrNotModifiedLogic(servletRequest, servletResponse, proxyResponse = this.proxyClient.execute(URIUtils.extractHost((URI)this.targetUri), (HttpRequest)proxyRequest), statusCode = proxyResponse.getStatusLine().getStatusCode())) {
                EntityUtils.consume((HttpEntity)proxyResponse.getEntity());
                return;
            }
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders(proxyResponse, servletResponse);
            this.copyResponseEntity(proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
                abortableHttpRequest.abort();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no " + "Location" + " header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    HttpHost host = URIUtils.extractHost((URI)this.targetUri);
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            try {
                entity.writeTo((OutputStream)servletOutputStream);
            }
            finally {
                this.closeQuietly((Closeable)servletOutputStream);
            }
        }
    }

    private String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        String queryString;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.targetUri.toString());
        if (servletRequest.getPathInfo() != null) {
            uri.append(servletRequest.getPathInfo());
        }
        if ((queryString = servletRequest.getQueryString()) != null && queryString.length() > 0) {
            uri.append('?');
            int fragIdx = queryString.indexOf(35);
            String queryNoFrag = fragIdx < 0 ? queryString : queryString.substring(0, fragIdx);
            uri.append(ProxyServlet.encodeUriQuery(queryNoFrag));
            if (fragIdx >= 0) {
                uri.append('#');
                uri.append(ProxyServlet.encodeUriQuery(queryString.substring(fragIdx + 1)));
            }
        }
        return uri.toString();
    }

    private String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl) {
        if (theUrl.startsWith(this.targetUri.toString())) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + theUrl.substring(this.targetUri.toString().length());
        }
        return theUrl;
    }

    static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

