 /* Copyright 2012 Yaqiang Wang,
 * yaqiang.wang@gmail.com
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.
 */
package org.meteoinfo.data.meteodata;

/**
 * Draw type 2D enum
 *
 * @author Yaqiang Wang
 */
public enum DrawType2D {

    Contour,
    /// <summary>
    /// Shaded
    /// </summary>
    Shaded,
    /// <summary>
    /// Grid fill
    /// </summary>
    Grid_Fill,
    /// <summary>
    /// Grid point
    /// </summary>
    Grid_Point,
    /// <summary>
    /// Vector
    /// </summary>
    Vector,
    /// <summary>
    /// Barb
    /// </summary>
    Barb,
    /// <summary>
    /// Streamline
    /// </summary>
    Streamline,
    /// <summary>
    /// Station point
    /// </summary>
    Station_Point,
    /// <summary>
    /// Weather symbol
    /// </summary>
    Weather_Symbol,
    /// <summary>
    /// Station model
    /// </summary>
    Station_Model,
    /// <summary>
    /// Trajectory line
    /// </summary>
    Traj_Line,
    /// <summary>
    /// Trajectory start point
    /// </summary>
    Traj_StartPoint,
    /// <summary>
    /// Trajectory point
    /// </summary>
    Traj_Point,
    /// <summary>
    /// Station information
    /// </summary>
    Station_Info,
    /// <summary>
    /// Image
    /// </summary>
    Image,
    /// <summary>
    /// Raster
    /// </summary>
    Raster
}
