/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service.commons;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EmailService {
    private final Logger log = LoggerFactory.getLogger(EmailService.class);
    @Inject
    private HtmlEmail htmlEmail;
    @Inject
    private Configuration configuration;

    @Async
    public void sendEmail(String to, String subject, String template, Object templateModel) {
        this.log.debug("Sending email to {}", (Object)to);
        try {
            StringWriter emailContent = new StringWriter();
            Template emailTemplate = this.configuration.getTemplate(template);
            emailTemplate.process(templateModel, (Writer)emailContent);
            this.htmlEmail.setSubject(subject);
            this.htmlEmail.addTo(to);
            this.htmlEmail.setHtmlMsg(emailContent.toString());
            this.htmlEmail.send();
        }
        catch (IOException e) {
            this.log.error("Error occured while creating email template", (Throwable)e);
        }
        catch (TemplateException e) {
            this.log.error("Error occured while creating email template", (Throwable)e);
        }
        catch (EmailException e) {
            this.log.warn("Email could not be sent to {}", (Object)to, (Object)e);
        }
    }
}

