/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.config.persistence;

import java.util.HashMap;
import javax.inject.Inject;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.meruvian.yama.core.user.User;
import org.meruvian.yama.webapi.service.commons.EmailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserRegisteredListener
implements PostInsertEventListener {
    private final Logger log = LoggerFactory.getLogger(UserRegisteredListener.class);
    @Inject
    private EmailService emailService;

    @Inject
    public UserRegisteredListener(EventListenerRegistry registry) {
        registry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)this);
    }

    public void onPostInsert(PostInsertEvent event) {
        if (event.getEntity() instanceof User) {
            User user = (User)event.getEntity();
            this.sendConfirmationEmail(user);
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return true;
    }

    @Async
    private void sendConfirmationEmail(User user) {
        this.log.debug("Sending confirmation email to {}", (Object)user.getUsername());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("user", user);
        model.put("activationUrl", "http://localhost:blabla");
        this.emailService.sendEmail(user.getEmail(), "Complete your registration", "email/user-signup.ftl", model);
    }
}

