/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service;

import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.meruvian.yama.social.core.SocialService;
import org.meruvian.yama.social.core.SocialServiceLocator;
import org.meruvian.yama.web.CredentialsService;
import org.meruvian.yama.webapi.service.SocialSignInService;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.stereotype.Service;

@Service
public class RestSocialSignInService
implements SocialSignInService {
    public static final String OAUTH_AUTH_URL = "/oauth/authorize";
    @Inject
    private SocialServiceLocator socialServiceLocator;
    @Inject
    private UsersConnectionRepository connectionRepository;
    @Inject
    private CredentialsService credentialsService;
    @Context
    private HttpServletRequest request;

    public Response socialSignIn(String provider) {
        String redirectUri = this.socialServiceLocator.getSocialService(provider).getAuthorizeUrl();
        return Response.seeOther((URI)URI.create(redirectUri)).build();
    }

    public Response socialSignInCallback(String provider, String code) {
        List userIds;
        Connection connection;
        SocialService socialService = this.socialServiceLocator.getSocialService(provider);
        if (socialService.isAuthorized(connection = socialService.createConnection(code, null)) && (userIds = this.connectionRepository.findUserIdsWithConnection(connection)).size() == 1) {
            String userId = (String)userIds.get(0);
            this.credentialsService.registerAuthentication(userId);
        }
        return Response.seeOther((URI)URI.create(this.getRedirectUrlAfterLogin())).build();
    }

    protected String getRedirectUrlAfterLogin() {
        SavedRequest savedRequest;
        HttpSession session = this.request.getSession(false);
        if (session != null && (savedRequest = (SavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST")) != null) {
            return savedRequest.getRedirectUrl();
        }
        return "/";
    }
}

