/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.service;

import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.meruvian.yama.core.role.Role;
import org.meruvian.yama.core.role.RoleRepository;
import org.meruvian.yama.webapi.service.RoleService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RestRoleService
implements RoleService {
    @Inject
    private RoleRepository roleRepository;

    public Role getRoleById(String id) {
        return (Role)this.roleRepository.findById(id);
    }

    public Page<Role> findRoleByKeyword(String keyword, Pageable pageable) {
        return this.roleRepository.findByNameOrDescription(keyword, keyword, 1, pageable);
    }

    @Transactional
    public void removeRole(String id) {
        this.getRoleById(id).getLogInformation().setActiveFlag(0);
    }

    @Transactional
    public Role saveRole(Role role) {
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            role.setId(null);
            role.setName(StringUtils.upperCase((String)role.getName()));
            return (Role)this.roleRepository.save((Object)role);
        }
        throw new BadRequestException("Id must be empty, use PUT method to update record");
    }

    @Transactional
    public Role updateRole(Role role) {
        Role r = (Role)this.roleRepository.findById(role.getId());
        r.setName(StringUtils.upperCase((String)role.getName()));
        r.setDescription(role.getDescription());
        return r;
    }
}

