/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.config;

import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
public class EmailConfig
implements EnvironmentAware {
    private RelaxedPropertyResolver props;

    @Bean
    @Scope(value="prototype")
    public HtmlEmail email() throws EmailException {
        HtmlEmail email = new HtmlEmail();
        email.setHostName(this.props.getProperty("host"));
        email.setSmtpPort(((Integer)this.props.getProperty("port", Integer.class, (Object)0)).intValue());
        email.setAuthentication(this.props.getProperty("username"), this.props.getProperty("password"));
        email.setFrom(this.props.getProperty("from_email"), this.props.getProperty("from_alias"));
        email.setSSLOnConnect(((Boolean)this.props.getProperty("ssl", Boolean.class, (Object)false)).booleanValue());
        email.setStartTLSEnabled(((Boolean)this.props.getProperty("tls", Boolean.class, (Object)false)).booleanValue());
        return email;
    }

    public void setEnvironment(Environment env) {
        this.props = new RelaxedPropertyResolver((PropertyResolver)env, "email.");
    }
}

