/*
 * Decompiled with CFR 0.152.
 */
package org.meruvian.yama.webapi.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
public class DatabaseConfig
implements EnvironmentAware {
    private RelaxedPropertyResolver dbProp;

    @Bean(destroyMethod="shutdown")
    public DataSource dataSource() {
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName(this.dbProp.getProperty("datasource"));
        config.setMaximumPoolSize(((Integer)this.dbProp.getProperty("max_pool_size", Integer.TYPE)).intValue());
        config.setConnectionTestQuery(this.dbProp.getProperty("test_query"));
        config.addDataSourceProperty("url", (Object)this.dbProp.getProperty("url"));
        config.addDataSourceProperty("user", (Object)this.dbProp.getProperty("username"));
        config.addDataSourceProperty("password", (Object)this.dbProp.getProperty("password"));
        return new HikariDataSource(config);
    }

    @Bean
    public SpringLiquibase liquibase(DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setChangeLog("classpath:/db/yama.xml");
        liquibase.setShouldRun(((Boolean)this.dbProp.getProperty("run_migration", Boolean.TYPE)).booleanValue());
        liquibase.setContexts("dev, prod");
        return liquibase;
    }

    public void setEnvironment(Environment environment) {
        this.dbProp = new RelaxedPropertyResolver((PropertyResolver)environment, "db.");
    }
}

