/*
 * Decompiled with CFR 0.152.
 */
package org.mediawiki.api.json;

import java.util.LinkedHashMap;
import java.util.Map;
import org.mediawiki.api.json.Api;
import org.mediawiki.api.json.ApiException;
import org.mediawiki.api.json.ApiResult;

public class RequestBuilder {
    private static final int INITIAL_CAPACITY = 14;
    private static final float LOAD_FACTOR = 0.8f;
    private final LinkedHashMap<String, String> params;
    private final Api api;

    RequestBuilder(Api apiToUse, String action) {
        this.api = apiToUse;
        this.params = new LinkedHashMap(14, 0.8f, false);
        this.params.put("action", action);
        this.params.put("format", "json");
    }

    public Map<String, String> getParams() {
        return new LinkedHashMap<String, String>(this.params);
    }

    public RequestBuilder param(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    private ApiResult setupRequest(int method) throws ApiException {
        return this.api.setupRequest(method, this);
    }

    public ApiResult get() throws ApiException {
        return this.setupRequest(1);
    }

    public ApiResult post() throws ApiException {
        return this.setupRequest(2);
    }
}

