/*
 * Decompiled with CFR 0.152.
 */
package org.mediawiki.api.json;

import com.github.kevinsawicki.http.HttpRequest;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mediawiki.api.json.Api;
import org.mediawiki.api.json.ApiException;

public class ApiResult {
    private final HttpRequest request;
    private final Api api;
    private Map<String, List<String>> headers;
    private JSONArray resultArray;
    private JSONObject resultObject;

    ApiResult(Api api, HttpRequest request) {
        this.api = api;
        this.request = request;
    }

    public void cancel() {
        this.request.disconnect();
    }

    public JSONArray asArray() throws ApiException {
        try {
            if (this.resultArray == null) {
                this.extractResponseHeaders();
                this.assertSuccess();
                this.resultArray = new JSONArray(this.request.body());
            }
            return this.resultArray;
        }
        catch (HttpRequest.HttpRequestException e) {
            throw new ApiException(e.getCause());
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    public JSONObject asObject() throws ApiException {
        try {
            if (this.resultObject == null) {
                this.extractResponseHeaders();
                this.assertSuccess();
                this.resultObject = new JSONObject(this.request.body());
            }
            return this.resultObject;
        }
        catch (HttpRequest.HttpRequestException e) {
            throw new ApiException(e.getCause());
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    private void extractResponseHeaders() {
        this.headers = this.request.headers();
        this.api.processHeaders(this);
    }

    private void assertSuccess() throws JSONException, ApiException {
        if (!this.request.ok()) {
            throw new ApiException(Integer.toString(this.request.code()), this.request.message());
        }
        String apiErrorKey = "MediaWiki-API-Error";
        if (this.headers.containsKey("MediaWiki-API-Error")) {
            JSONObject error = new JSONObject(this.request.body()).optJSONObject("error");
            if (error != null) {
                throw new ApiException(error.optString("code"), error.optString("info"));
            }
            throw new ApiException(this.headers.get("MediaWiki-API-Error").get(0), "");
        }
    }

    public Map<String, List<String>> getHeaders() throws NullPointerException {
        if (this.headers != null) {
            return this.headers;
        }
        throw new NullPointerException("getHeaders must be called after asArray or asObject");
    }
}

