/*
 * Decompiled with CFR 0.152.
 */
package org.mediawiki.api.json;

import com.github.kevinsawicki.http.HttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.mediawiki.api.json.ApiException;
import org.mediawiki.api.json.ApiResult;
import org.mediawiki.api.json.OnHeaderCheckListener;
import org.mediawiki.api.json.RequestBuilder;

public class Api {
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    private URL apiUrl;
    private Map<String, String> customHeaders;
    private static final String DEFAULT_ENDPOINT = "/w/api.php";
    private OnHeaderCheckListener onHeaderCheckListener;

    public Api(String domain) {
        this(domain, true, DEFAULT_ENDPOINT, null);
    }

    public Api(String domain, String userAgent) {
        this(domain, true, DEFAULT_ENDPOINT, new HashMap<String, String>());
        this.customHeaders.put("User-Agent", userAgent);
    }

    public Api(String domain, String userAgent, Map<String, String> customHeaders) {
        this(domain, true, DEFAULT_ENDPOINT, customHeaders);
        this.customHeaders.put("User-Agent", userAgent);
    }

    public Api(String domain, Map<String, String> customHeaders) {
        this(domain, true, DEFAULT_ENDPOINT, customHeaders);
    }

    public Api(String domain, boolean useSecure) {
        this(domain, useSecure, DEFAULT_ENDPOINT, null);
    }

    public Api(String domain, boolean useSecure, String endpointPath) {
        this(domain, useSecure, endpointPath, null);
    }

    public Api(String domain, boolean useSecure, String endpointPath, Map<String, String> customHeaders) {
        String protocol = useSecure ? "https" : "http";
        try {
            this.apiUrl = new URL(protocol, domain, endpointPath);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.customHeaders = customHeaders;
    }

    public URL getApiUrl() {
        return this.apiUrl;
    }

    public RequestBuilder action(String action) {
        return new RequestBuilder(this, action);
    }

    public ApiResult setupRequest(int method, RequestBuilder requestBuilder) throws ApiException {
        HttpRequest request;
        switch (method) {
            case 1: {
                request = HttpRequest.get((CharSequence)this.getApiUrl().toString(), this.encodeParams(requestBuilder.getParams()), (boolean)false);
                break;
            }
            case 2: {
                request = HttpRequest.post((CharSequence)this.getApiUrl().toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown argument passed for parameter method");
            }
        }
        request.acceptGzipEncoding();
        request.uncompress(true);
        if (this.customHeaders != null) {
            request = request.headers(this.customHeaders);
        }
        if (method == 2) {
            try {
                request.form(requestBuilder.getParams());
            }
            catch (HttpRequest.HttpRequestException e) {
                throw new ApiException(e.getCause());
            }
            catch (SecurityException e) {
                throw new ApiException(e);
            }
        }
        return new ApiResult(this, request);
    }

    private Map<String, String> encodeParams(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                entry.setValue(URLEncoder.encode(entry.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return params;
    }

    public static void setConnectionFactory(HttpRequest.ConnectionFactory factory) {
        HttpRequest.setConnectionFactory((HttpRequest.ConnectionFactory)factory);
    }

    public void setHeaderCheckListener(OnHeaderCheckListener listener) {
        this.onHeaderCheckListener = listener;
    }

    public void processHeaders(ApiResult result) {
        if (this.onHeaderCheckListener != null) {
            this.onHeaderCheckListener.onHeaderCheck(result, this.apiUrl);
        }
    }
}

