/*
 * Decompiled with CFR 0.152.
 */
package org.marvec.encryptor.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.marvec.encryptor.util.EncryptionException;

public class EncryptionUtil {
    private static final String ALGORITHM = "RSA";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String PRIVATE_KEY_RESOURCE = "/org/marvec/encryptor/private_key.pem";
    private static final String PUBLIC_KEY_RESOURCE = "/org/marvec/encryptor/public_key.pem";
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public EncryptionUtil() throws EncryptionException {
        try {
            this.publicKey = this.getPemPublicKey(this.readResource(PUBLIC_KEY_RESOURCE));
            this.privateKey = this.getPemPrivateKey(this.readResource(PRIVATE_KEY_RESOURCE));
        }
        catch (IOException e) {
            throw new EncryptionException("Unable to initialize encryptor: ", e);
        }
    }

    public EncryptionUtil(String publicKey, String privateKey) throws EncryptionException {
        this.publicKey = publicKey != null ? this.getPemPublicKey(publicKey) : null;
        this.privateKey = privateKey != null ? this.getPemPrivateKey(privateKey) : null;
    }

    private String readResource(String resourceName) throws IOException {
        return new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resourceName), DEFAULT_CHARSET)).lines().collect(Collectors.joining("\n"));
    }

    private PrivateKey getPemPrivateKey(String keyString) throws EncryptionException {
        try {
            String privKeyPEM = keyString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\v", "");
            Base64 b64 = new Base64();
            byte[] decoded = b64.decode(privKeyPEM);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return kf.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Unable to obtain private key: ", e);
        }
    }

    private PublicKey getPemPublicKey(String keyString) throws EncryptionException {
        try {
            String publicKeyPEM = keyString.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\v", "");
            Base64 b64 = new Base64();
            byte[] decoded = b64.decode(publicKeyPEM);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(decoded);
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            return kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new EncryptionException("Unable to obtain public key: ", e);
        }
    }

    public byte[] encrypt(String text, KeyType keyType) throws EncryptionException {
        Key key = keyType == KeyType.PRIVATE ? this.privateKey : this.publicKey;
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key);
            byte[] cipherText = cipher.doFinal(text.getBytes(DEFAULT_CHARSET));
            return cipherText;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to encrypt message: ", e);
        }
    }

    public String decrypt(byte[] text, KeyType keyType) throws EncryptionException {
        Key key = keyType == KeyType.PRIVATE ? this.privateKey : this.publicKey;
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key);
            byte[] dectyptedText = cipher.doFinal(text);
            return new String(dectyptedText, DEFAULT_CHARSET);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new EncryptionException("Unable to decrypt message: ", e);
        }
    }

    public String sign(String message) throws EncryptionException {
        try {
            Signature sign = Signature.getInstance("SHA1withRSA");
            sign.initSign(this.privateKey);
            sign.update(message.getBytes(DEFAULT_CHARSET));
            return new String(Base64.encodeBase64((byte[])sign.sign()), DEFAULT_CHARSET);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new EncryptionException("Unable to sign message: ", e);
        }
    }

    public boolean verify(String message, String signature) throws EncryptionException {
        try {
            Signature sign = Signature.getInstance("SHA1withRSA");
            sign.initVerify(this.publicKey);
            sign.update(message.getBytes(DEFAULT_CHARSET));
            return sign.verify(Base64.decodeBase64((byte[])signature.getBytes(DEFAULT_CHARSET)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new EncryptionException("Unable to verify message: ", e);
        }
    }

    public static enum KeyType {
        PRIVATE,
        PUBLIC;

    }
}

