/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class RecursiveArgument
extends Argument {
    public static final int TYPE_ID_RECURSIVE = 102;
    public static final String TYPE_DESC_RECURSIVE = "User defined recursive argument";
    private List<Double> baseValues;
    private int recursiveCounter;
    private int startingIndex;

    public RecursiveArgument(String argumentName, String recursiveExpressionString, String indexName) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (argumentName.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = new Argument(indexName, new PrimitiveElement[0]);
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.setDescription(argumentName);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String argumentName, String recursiveExpressionString, Argument n, PrimitiveElement ... elements) {
        super(argumentName, recursiveExpressionString, new PrimitiveElement[0]);
        if (argumentName.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = n;
            this.argumentExpression.addArguments(n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(elements);
            this.argumentExpression.setDescription(argumentName);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String argumentDefinitionString, PrimitiveElement ... elements) {
        super(argumentDefinitionString, new PrimitiveElement[0]);
        if (mXparser.regexMatch(argumentDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.recursiveCounter = -1;
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(elements);
            this.argumentExpression.setDescription(argumentDefinitionString);
        } else {
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + argumentDefinitionString + "] Invalid argument definition (patterns: f(n) = f(n-1) ...  ).");
        }
    }

    public void addBaseCase(int index, double value) {
        int recSize = this.baseValues.size();
        if (index > recSize - 1) {
            for (int i = recSize; i < index; ++i) {
                this.baseValues.add(Double.NaN);
            }
            this.baseValues.add(value);
        } else {
            this.baseValues.set(index, value);
        }
    }

    public void resetAllCases() {
        this.baseValues.clear();
        this.recursiveCounter = -1;
    }

    public double getArgumentValue(double index) {
        if (this.recursiveCounter == -1) {
            this.startingIndex = (int)Math.round(index);
        }
        int recSize = this.baseValues.size();
        int idx = (int)Math.round(index);
        ++this.recursiveCounter;
        if (this.recursiveCounter <= this.startingIndex && idx <= this.startingIndex) {
            if (idx >= 0 && idx < recSize && !Double.isNaN(this.baseValues.get(idx))) {
                --this.recursiveCounter;
                return this.baseValues.get(idx);
            }
            if (idx >= 0) {
                this.n.setArgumentValue(idx);
                Expression newExp = new Expression(this.argumentExpression.expressionString, this.argumentExpression.argumentsList, this.argumentExpression.functionsList, this.argumentExpression.constantsList, true, this.argumentExpression.UDFExpression, this.argumentExpression.UDFVariadicParamsAtRunTime);
                newExp.setDescription(super.getArgumentName());
                if (super.getVerboseMode()) {
                    newExp.setVerboseMode();
                }
                double value = newExp.calculate();
                this.addBaseCase(idx, value);
                --this.recursiveCounter;
                return value;
            }
            --this.recursiveCounter;
            return Double.NaN;
        }
        --this.recursiveCounter;
        return Double.NaN;
    }
}

