/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.regressiontesting;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.regressiontesting.FunExt;

public class RegTestSyntax {
    private static Expression[] exp;

    private static boolean runTest(int testId) {
        mXparser.consolePrint("[" + testId + "] ");
        boolean testResult = false;
        String expStr = "";
        String msg = "";
        Argument x = new Argument("x", new PrimitiveElement[0]);
        switch (testId) {
            case 0: {
                Expression e;
                expStr = "";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 1: {
                Expression e;
                expStr = "1++";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 2: {
                Expression e;
                expStr = "1+1-";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 3: {
                Expression e;
                expStr = "+-1";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 4: {
                Expression e;
                expStr = "1-(2))";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 5: {
                Expression e;
                expStr = "1id";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 6: {
                Expression e;
                expStr = "(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 7: {
                Expression e;
                expStr = "f(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 8: {
                Expression e;
                expStr = "sin";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 9: {
                Expression e;
                expStr = "sin()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 10: {
                Expression e;
                expStr = "cos(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 11: {
                Expression e;
                expStr = "log";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 12: {
                Expression e;
                expStr = "log()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 13: {
                Expression e;
                expStr = "log(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 14: {
                Expression e;
                expStr = "log(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 15: {
                Expression e;
                expStr = "if";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 16: {
                Expression e;
                expStr = "if()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 17: {
                Expression e;
                expStr = "if(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 18: {
                Expression e;
                expStr = "if(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 19: {
                Expression e;
                expStr = "if(1,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 20: {
                Expression e;
                expStr = "pi()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 21: {
                Expression e;
                expStr = "pi(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 22: {
                Expression e;
                expStr = "[K*]()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 23: {
                Expression e;
                expStr = "[K*](12)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 24: {
                Expression e;
                expStr = "min";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 25: {
                Expression e;
                expStr = "min()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 26: {
                Expression e;
                expStr = "max";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 27: {
                Expression e;
                expStr = "max()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 28: {
                Expression e;
                expStr = "iff";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 29: {
                Expression e;
                expStr = "iff()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 30: {
                Expression e;
                expStr = "iff(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 31: {
                Expression e;
                expStr = "iff(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 32: {
                Expression e;
                expStr = "iff(1,2,3,4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 33: {
                Expression e;
                expStr = "sum";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 34: {
                Expression e;
                expStr = "sum()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 35: {
                Expression e;
                expStr = "sum(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 36: {
                Expression e;
                expStr = "sum(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 37: {
                Expression e;
                expStr = "sum(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 38: {
                Expression e;
                expStr = "sum(1,2,3,4,5,6)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 39: {
                Expression e;
                expStr = "prod()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 40: {
                Expression e;
                expStr = "prod(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 41: {
                Expression e;
                expStr = "prod(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 42: {
                Expression e;
                expStr = "prod(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 43: {
                Expression e;
                expStr = "prod(1,2,3,4,5,6)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 44: {
                Expression e;
                expStr = "sum(1,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 45: {
                Expression e;
                expStr = "sum(a*b,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 46: {
                Expression e;
                expStr = "sum(i,1,a,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 47: {
                Expression e;
                expStr = "prod(1,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 48: {
                Expression e;
                expStr = "prod(a*b,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 49: {
                Expression e;
                expStr = "prod(i,1,a,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 50: {
                Expression e;
                expStr = "int";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 51: {
                Expression e;
                expStr = "int()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 52: {
                Expression e;
                expStr = "int(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 53: {
                Expression e;
                expStr = "int(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 54: {
                Expression e;
                expStr = "int(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 55: {
                Expression e;
                expStr = "int(1,2,3,4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 56: {
                Expression e;
                x = new Argument("x", 5.0);
                expStr = "int(,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 57: {
                Expression e;
                expStr = "int(1,2,0,1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 58: {
                Expression e;
                expStr = "der";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 59: {
                Expression e;
                expStr = "der()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 60: {
                Expression e;
                expStr = "der(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 61: {
                Expression e;
                expStr = "der(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 62: {
                Expression e;
                expStr = "der(1,2,3,4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 63: {
                Expression e;
                expStr = "der(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 64: {
                Expression e;
                expStr = "der+";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 65: {
                Expression e;
                expStr = "der+()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 66: {
                Expression e;
                expStr = "der+(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 67: {
                Expression e;
                expStr = "der+(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 68: {
                Expression e;
                expStr = "der+(1,2,3,4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 69: {
                Expression e;
                expStr = "der+(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 70: {
                Expression e;
                expStr = "der-";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 71: {
                Expression e;
                expStr = "der-()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 72: {
                Expression e;
                expStr = "der-(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 73: {
                Expression e;
                expStr = "der-(1,2,3)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 74: {
                Expression e;
                expStr = "der-(1,2,3,4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 75: {
                Expression e;
                expStr = "der-(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 76: {
                Expression e;
                expStr = "diff";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 77: {
                Expression e;
                expStr = "diff()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 78: {
                Expression e;
                expStr = "diff(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 79: {
                Expression e;
                expStr = "diff(1,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 80: {
                Expression e;
                expStr = "diff(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 81: {
                Expression e;
                expStr = "difb";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 82: {
                Expression e;
                expStr = "difb()";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 83: {
                Expression e;
                expStr = "difb(1)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 84: {
                Expression e;
                expStr = "difb(1,2,3,4)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 85: {
                Expression e;
                expStr = "difb(1,2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> ");
                break;
            }
            case 86: {
                Expression e;
                expStr = "f()=x+y";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f", f);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 87: {
                Expression e;
                expStr = "f(1,x,y)=x+y";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f", f);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 88: {
                Expression e;
                expStr = "f(1)=x+y";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f", f);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 89: {
                Expression e;
                expStr = "f(x,)=x+y";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f", f);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 90: {
                Expression e;
                expStr = "f(x,  a, x, )=x+y";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f", f);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 91: {
                Expression e;
                expStr = "  f   (x ,   y,    z   )  = x +  y  +z  ";
                mXparser.consolePrint(expStr + " ...... ");
                Function f = new Function(expStr, new PrimitiveElement[0]);
                msg = f.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("f(1,2,3)", f);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") == -1 && reg == syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 92: {
                Expression e;
                expStr = "x()=y+z";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 93: {
                Expression e;
                expStr = "x(1,a,b)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 94: {
                Expression e;
                expStr = "x(1)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 95: {
                Expression e;
                expStr = "x(a,)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 96: {
                Expression e;
                expStr = "x(a, b, c,)=a+c";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 97: {
                Expression e;
                expStr = "  x (  a, b   , c  ) = a+b+c";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new Argument("a = 1", new PrimitiveElement[0]), new Argument("b = 2", new PrimitiveElement[0]), new Argument("   c = 3", new PrimitiveElement[0]));
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") == -1 && reg == syn && e.calculate() == 6.0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + e.calculate() + " " + msg);
                break;
            }
            case 98: {
                Expression e;
                expStr = "x 5";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 99: {
                Expression e;
                expStr = "  x = 5 + 1 + 2";
                mXparser.consolePrint(expStr + " ...... ");
                x = new Argument(expStr, new Argument("a = 1", new PrimitiveElement[0]), new Argument("b = 2", new PrimitiveElement[0]), new Argument("   c = 3", new PrimitiveElement[0]));
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") == -1 && reg == syn && e.calculate() == 8.0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + e.calculate() + " " + msg);
                break;
            }
            case 100: {
                Expression e;
                expStr = "f(n,m)=n*f(n-1)";
                mXparser.consolePrint(expStr + " ...... ");
                x = new RecursiveArgument(expStr, new PrimitiveElement[0]);
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument definition") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 101: {
                Expression e;
                expStr = "RecursiveArgument name    1fa";
                mXparser.consolePrint(expStr + " ...... ");
                x = new RecursiveArgument("1fa", "f(n-1)", "n");
                msg = x.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x(1)", x);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("Invalid argument name") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 102: {
                Expression e;
                expStr = "x()=y+z";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 103: {
                Expression e;
                expStr = "x(1,a,b)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 104: {
                Expression e;
                expStr = "x(1)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 105: {
                Expression e;
                expStr = "x(a,)=a+b";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 106: {
                Expression e;
                expStr = "x(a, b, c,)=a+c";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 107: {
                Expression e;
                expStr = "  x = a+b+c";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new Argument("a = 1", new PrimitiveElement[0]), new Argument("b = 2", new PrimitiveElement[0]), new Argument("   c = 3", new PrimitiveElement[0]));
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") == -1 && reg == syn && e.calculate() == 6.0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + e.calculate() + " " + msg);
                break;
            }
            case 108: {
                Expression e;
                expStr = "x 5";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 109: {
                Expression e;
                expStr = "  x = 5 + 1 + 2";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant(expStr, new PrimitiveElement[0]);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("x", c1);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("pattern not mathes") == -1 && reg == syn && e.calculate() == 8.0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + e.calculate() + " " + msg);
                break;
            }
            case 110: {
                Expression e;
                expStr = "Constant name    1fa";
                mXparser.consolePrint(expStr + " ...... ");
                Constant c1 = new Constant("1fa", 1.0);
                msg = c1.getErrorMessage();
                RegTestSyntax.exp[testId] = e = new Expression("1fa", c1);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (msg.indexOf("invalid constant name") >= 0) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 111: {
                Expression e;
                Function ff = new Function("ff", new FunExt());
                expStr = "ff(4,5)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, ff);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 112: {
                Expression e;
                Function ff = new Function("ff", new FunExt());
                expStr = "ff(4,5,6)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, ff);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (!syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 113: {
                Expression e;
                expStr = "solve(2*x - 4, x+y, -10, 10)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (!syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 114: {
                Expression e;
                mXparser.unremoveAllBuiltinTokens();
                mXparser.removeBuiltinTokens("sin");
                expStr = "sin(2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                mXparser.unremoveAllBuiltinTokens();
                if (!syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 115: {
                Expression e;
                mXparser.unmodifyAllBuiltinTokens();
                mXparser.modifyBuiltinToken("sin", "sinos");
                expStr = "sin(2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                mXparser.unmodifyAllBuiltinTokens();
                if (!syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 116: {
                Expression e;
                mXparser.unmodifyAllBuiltinTokens();
                mXparser.modifyBuiltinToken("sin", "sinos");
                expStr = "sinos(2)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                mXparser.unmodifyAllBuiltinTokens();
                if (syn) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 117: {
                Expression e;
                mXparser.setNotToOverrideBuiltinTokens();
                Function sin = new Function("sin(x,y) = 2*x + y", new PrimitiveElement[0]);
                Argument ee = new Argument("e = 5", new PrimitiveElement[0]);
                Constant pi = new Constant("pi = 2", new PrimitiveElement[0]);
                expStr = "sin(e,pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, sin, ee, pi);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 118: {
                Expression e;
                mXparser.setToOverrideBuiltinTokens();
                Function sin = new Function("sin(x,y) = 2*x + y", new PrimitiveElement[0]);
                Argument ee = new Argument("e = 5", new PrimitiveElement[0]);
                Constant pi = new Constant("pi = 2", new PrimitiveElement[0]);
                expStr = "sin(e,pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, sin, ee, pi);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 119: {
                Expression e;
                expStr = "h.1234567890aBcDeF + H.001234567890aBcDeF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 120: {
                Expression e;
                expStr = "o.12345670 + O.0012345670";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 121: {
                Expression e;
                expStr = "b.101010 + B.000101010";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 122: {
                Expression e;
                expStr = "h.1234567890aBcDeFu + y.001234567890aBcDeF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 123: {
                Expression e;
                expStr = "o.123456708 + O.00123456709";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 124: {
                Expression e;
                expStr = "b.2101010 + B.0001010103";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 125: {
                Expression e;
                expStr = "b1. + B1.111";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 126: {
                Expression e;
                expStr = "b1.111 + B1.1101";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 127: {
                Expression e;
                expStr = "b2.01 + B2.0101";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 128: {
                Expression e;
                expStr = "b2.012 + B2.0101";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 129: {
                Expression e;
                expStr = "b3.012 + B3.0012";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 130: {
                Expression e;
                expStr = "b3.012 + B3.00123";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 131: {
                Expression e;
                expStr = "b4.0123 + B4.00123";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 132: {
                Expression e;
                expStr = "b4.01234 + B4.00123";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 133: {
                Expression e;
                expStr = "b5.01234 + B5.001234";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 134: {
                Expression e;
                expStr = "b5.012345 + B5.001234";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 135: {
                Expression e;
                expStr = "b6.012345 + B6.0012345";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 136: {
                Expression e;
                expStr = "b6.012345 + B6.00123456";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 137: {
                Expression e;
                expStr = "b7.0123456 + B7.00123456";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 138: {
                Expression e;
                expStr = "b7.0123456 + B7.001234568";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 139: {
                Expression e;
                expStr = "b8.01234567 + B8.001234567";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 140: {
                Expression e;
                expStr = "b8.01234567 + B8.0012345679";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 141: {
                Expression e;
                expStr = "b9.012345678 + B9.0012345678";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 142: {
                Expression e;
                expStr = "b9.0123456789 + B9.0012345678";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 143: {
                Expression e;
                expStr = "b10.0123456789 + B10.00123456789";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 144: {
                Expression e;
                expStr = "b10.0123456789 + B10.00123456789a";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 145: {
                Expression e;
                expStr = "b11.0123456789a + B11.00123456789A";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 146: {
                Expression e;
                expStr = "b11.0123456789a + B11.00123456789Ab";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 147: {
                Expression e;
                expStr = "b12.0123456789ab + B12.00123456789AB";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 148: {
                Expression e;
                expStr = "b12.0123456789abC + B12.00123456789AB";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 149: {
                Expression e;
                expStr = "b13.0123456789abc + B13.00123456789ABC";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 150: {
                Expression e;
                expStr = "b13.0123456789abc + B13.00123456789ABCd";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 151: {
                Expression e;
                expStr = "b14.0123456789abcd + B14.00123456789ABCD";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 152: {
                Expression e;
                expStr = "b14.0123456789abcdE + B14.00123456789ABCD";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 153: {
                Expression e;
                expStr = "b15.0123456789abcde + B15.00123456789ABCDE";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 154: {
                Expression e;
                expStr = "b15.0123456789abcde + B15.00123456789ABCDEf";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 155: {
                Expression e;
                expStr = "b16.0123456789abcdef + B16.00123456789ABCDEF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 156: {
                Expression e;
                expStr = "b16.0123456789abcdefg + B16.00123456789ABCDEF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 157: {
                Expression e;
                expStr = "b16.0123456789abcdef + B16.00123456789ABCDEF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 158: {
                Expression e;
                expStr = "b16.0123456789abcdefg + B16.00123456789ABCDEF";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 159: {
                Expression e;
                expStr = "b17.0123456789abcdefg + B17.00123456789ABCDEFG";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 160: {
                Expression e;
                expStr = "b17.0123456789abcdefg + B17.00123456789ABCDEFGh";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 161: {
                Expression e;
                expStr = "b18.0123456789abcdefgh + B18.00123456789ABCDEFGH";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 162: {
                Expression e;
                expStr = "b18.0123456789abcdefghI + B18.00123456789ABCDEFGH";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 163: {
                Expression e;
                expStr = "b19.0123456789abcdefghi + B19.00123456789ABCDEFGI";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 164: {
                Expression e;
                expStr = "b19.0123456789abcdefghi + B19.00123456789ABCDEFGIj";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 165: {
                Expression e;
                expStr = "b20.0123456789abcdefghij + B20.00123456789ABCDEFGIJ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 166: {
                Expression e;
                expStr = "b20.0123456789abcdefghijK + B20.00123456789ABCDEFGIJ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 167: {
                Expression e;
                expStr = "b21.0123456789abcdefghijk + B21.00123456789ABCDEFGIJK";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 168: {
                Expression e;
                expStr = "b21.0123456789abcdefghijk + B21.00123456789ABCDEFGIJKl";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 169: {
                Expression e;
                expStr = "b22.0123456789abcdefghijkl + B22.00123456789ABCDEFGIJKL";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 170: {
                Expression e;
                expStr = "b22.0123456789abcdefghijklM + B22.00123456789ABCDEFGIJKL";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 171: {
                Expression e;
                expStr = "b23.0123456789abcdefghijklm + B23.00123456789ABCDEFGIJKLM";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 172: {
                Expression e;
                expStr = "b23.0123456789abcdefghijklm + B23.00123456789ABCDEFGIJKLMn";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 173: {
                Expression e;
                expStr = "b24.0123456789abcdefghijklmn + B24.00123456789ABCDEFGIJKLMN";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 174: {
                Expression e;
                expStr = "b24.0123456789abcdefghijklmnO + B24.00123456789ABCDEFGIJKLMN";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 175: {
                Expression e;
                expStr = "b25.0123456789abcdefghijklmno + B25.00123456789ABCDEFGIJKLMNO";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 176: {
                Expression e;
                expStr = "b25.0123456789abcdefghijklmno + B25.00123456789ABCDEFGIJKLMNOp";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 177: {
                Expression e;
                expStr = "b26.0123456789abcdefghijklmnop + B26.00123456789ABCDEFGIJKLMNOP";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 178: {
                Expression e;
                expStr = "b26.0123456789abcdefghijklmnop + B26.00123456789ABCDEFGIJKLMNOPq";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 179: {
                Expression e;
                expStr = "b27.0123456789abcdefghijklmnopq + B27.00123456789ABCDEFGIJKLMNOPQ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 180: {
                Expression e;
                expStr = "b27.0123456789abcdefghijklmnopqR + B27.00123456789ABCDEFGIJKLMNOPQ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 181: {
                Expression e;
                expStr = "b28.0123456789abcdefghijklmnopqr + B28.00123456789ABCDEFGIJKLMNOPQR";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 182: {
                Expression e;
                expStr = "b28.0123456789abcdefghijklmnopqr + B28.00123456789ABCDEFGIJKLMNOPQRs";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 183: {
                Expression e;
                expStr = "b29.0123456789abcdefghijklmnopqrs + B29.00123456789ABCDEFGIJKLMNOPQRS";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 184: {
                Expression e;
                expStr = "b29.0123456789abcdefghijklmnopqrsT + B29.00123456789ABCDEFGIJKLMNOPQRS";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 185: {
                Expression e;
                expStr = "b30.0123456789abcdefghijklmnopqrst + B30.00123456789ABCDEFGIJKLMNOPQRST";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 186: {
                Expression e;
                expStr = "b30.0123456789abcdefghijklmnopqrst + B30.00123456789ABCDEFGIJKLMNOPQRSTu";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 187: {
                Expression e;
                expStr = "b31.0123456789abcdefghijklmnopqrstu + B31.00123456789ABCDEFGIJKLMNOPQRSTU";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 188: {
                Expression e;
                expStr = "b31.0123456789abcdefghijklmnopqrstuV + B31.00123456789ABCDEFGIJKLMNOPQRSTU";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 189: {
                Expression e;
                expStr = "b32.0123456789abcdefghijklmnopqrstuv + B32.00123456789ABCDEFGIJKLMNOPQRSTUV";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 190: {
                Expression e;
                expStr = "b32.0123456789abcdefghijklmnopqrstuv + B32.00123456789ABCDEFGIJKLMNOPQRSTUVw";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 191: {
                Expression e;
                expStr = "b33.0123456789abcdefghijklmnopqrstuvw + B33.00123456789ABCDEFGIJKLMNOPQRSTUVW";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 192: {
                Expression e;
                expStr = "b33.0123456789abcdefghijklmnopqrstuvwX + B33.00123456789ABCDEFGIJKLMNOPQRSTUVW";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 193: {
                Expression e;
                expStr = "b34.0123456789abcdefghijklmnopqrstuvwx + B34.00123456789ABCDEFGIJKLMNOPQRSTUVWX";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 194: {
                Expression e;
                expStr = "b34.0123456789abcdefghijklmnopqrstuvwx + B34.00123456789ABCDEFGIJKLMNOPQRSTUVWXy";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 195: {
                Expression e;
                expStr = "b35.0123456789abcdefghijklmnopqrstuvwxy + B35.00123456789ABCDEFGIJKLMNOPQRSTUVWXY";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 196: {
                Expression e;
                expStr = "b35.0123456789abcdefghijklmnopqrstuvwxyZ + B35.00123456789ABCDEFGIJKLMNOPQRSTUVWXY";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 197: {
                Expression e;
                expStr = "b36.0123456789abcdefghijklmnopqrstuvwxyz + B36.00123456789ABCDEFGIJKLMNOPQRSTUVWXYZ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 198: {
                Expression e;
                expStr = "b36.0123456789abcdefghijklmnopqrstuvwxyz\u0105 + B36.00123456789ABCDEFGIJKLMNOPQRSTUVWXYZ";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 199: {
                Expression e;
                x = new Argument("x = pi", new PrimitiveElement[0]);
                expStr = "der( sin(x), x )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 200: {
                Expression e;
                x = new Argument("x = pi", new PrimitiveElement[0]);
                expStr = "der( sin(x), x, 0.01, 100 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 201: {
                Expression e;
                expStr = "der( sin(x), x , pi )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 202: {
                Expression e;
                expStr = "der( sin(x), x , pi )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 203: {
                Expression e;
                expStr = "der( sin(x), x , pi, 0.01, 100 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 204: {
                Expression e;
                expStr = "der( sin(x), x , pi, 0.01, 100 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, x);
                boolean reg = true;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 205: {
                Expression e;
                expStr = "der( sin(x), x )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 206: {
                Expression e;
                expStr = "der( sin(x), x, 0.1, 100 )";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                boolean reg = false;
                boolean syn = e.checkSyntax();
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 207: {
                Expression e;
                expStr = "sin(pi)+cos(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unremoveAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                boolean reg = true;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 208: {
                Expression e;
                expStr = "sin(pi)+cos(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unremoveAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.removeBuiltinTokens("sin", "cos");
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.unremoveAllBuiltinTokens();
                break;
            }
            case 209: {
                Expression e;
                expStr = "sin(pi)+cos(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unremoveAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.removeBuiltinTokens("sin", "cos");
                syn = e.checkSyntax();
                mXparser.unremoveBuiltinTokens("cos");
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.unremoveAllBuiltinTokens();
                break;
            }
            case 210: {
                Expression e;
                expStr = "sin(pi)+cos(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unremoveAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.removeBuiltinTokens("sin", "cos");
                syn = e.checkSyntax();
                mXparser.unremoveBuiltinTokens("cos");
                syn = e.checkSyntax();
                mXparser.unremoveAllBuiltinTokens();
                syn = e.checkSyntax();
                boolean reg = true;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 211: {
                Expression e;
                expStr = "sine(pi)+cosine(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unmodifyAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 212: {
                Expression e;
                expStr = "sine(pi)+cosine(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unmodifyAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("sin", "sine");
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.unmodifyAllBuiltinTokens();
                break;
            }
            case 213: {
                Expression e;
                expStr = "sine(pi)+cosine(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unmodifyAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("sin", "sine");
                syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("cos", "cosine", "My new cosine token");
                syn = e.checkSyntax();
                boolean reg = true;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.unmodifyAllBuiltinTokens();
                break;
            }
            case 214: {
                Expression e;
                expStr = "sine(pi)+cosine(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unmodifyAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("sin", "sine");
                syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("cos", "cosine", "My new cosine token");
                syn = e.checkSyntax();
                mXparser.unmodifyBuiltinTokens("sin");
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.unmodifyAllBuiltinTokens();
                break;
            }
            case 215: {
                Expression e;
                expStr = "sine(pi)+cosine(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                RegTestSyntax.exp[testId] = e = new Expression(expStr, new PrimitiveElement[0]);
                mXparser.unmodifyAllBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("sin", "sine");
                syn = e.checkSyntax();
                mXparser.modifyBuiltinToken("cos", "cosine", "My new cosine token");
                syn = e.checkSyntax();
                mXparser.unmodifyAllBuiltinTokens();
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 216: {
                Expression e;
                expStr = "sin(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                Function sin = new Function("sin(x) = 2*x", new PrimitiveElement[0]);
                Constant pi = new Constant("pi = 1", new PrimitiveElement[0]);
                RegTestSyntax.exp[testId] = e = new Expression(expStr, sin, pi);
                mXparser.setNotToOverrideBuiltinTokens();
                boolean syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                break;
            }
            case 217: {
                Expression e;
                expStr = "sin(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                Function sin = new Function("sin(x) = 2*x", new PrimitiveElement[0]);
                Constant pi = new Constant("pi = 1", new PrimitiveElement[0]);
                RegTestSyntax.exp[testId] = e = new Expression(expStr, sin, pi);
                mXparser.setNotToOverrideBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.setToOverrideBuiltinTokens();
                syn = e.checkSyntax();
                boolean reg = true;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
                mXparser.setNotToOverrideBuiltinTokens();
                break;
            }
            case 218: {
                Expression e;
                expStr = "sin(pi)";
                mXparser.consolePrint(expStr + " ...... ");
                Function sin = new Function("sin(x) = 2*x", new PrimitiveElement[0]);
                Constant pi = new Constant("pi = 1", new PrimitiveElement[0]);
                RegTestSyntax.exp[testId] = e = new Expression(expStr, sin, pi);
                mXparser.setNotToOverrideBuiltinTokens();
                boolean syn = e.checkSyntax();
                mXparser.setToOverrideBuiltinTokens();
                syn = e.checkSyntax();
                mXparser.setNotToOverrideBuiltinTokens();
                syn = e.checkSyntax();
                boolean reg = false;
                if (syn == reg) {
                    testResult = true;
                }
                mXparser.consolePrint(syn + " reg ... " + reg + " --> " + " -----> " + msg);
            }
        }
        if (testResult) {
            mXparser.consolePrint("OK");
        } else {
            mXparser.consolePrint("ERROR");
        }
        return testResult;
    }

    public static int start() {
        int numberOfTests = 218;
        int nOk = 0;
        int nError = 0;
        exp = new Expression[numberOfTests + 1];
        boolean[] tests = new boolean[numberOfTests + 1];
        long start = System.currentTimeMillis();
        for (int testId = 0; testId <= numberOfTests; ++testId) {
            boolean test;
            tests[testId] = test = RegTestSyntax.runTest(testId);
            if (test) {
                ++nOk;
            } else {
                ++nError;
            }
            mXparser.consolePrintln(", time: " + exp[testId].getComputingTime() + " s.");
        }
        long end = System.currentTimeMillis();
        mXparser.consolePrintln("OK : " + nOk + ", ERRORs: " + nError + ", total time: " + (double)(end - start) / 1000.0 + " s.");
        for (int testId = 0; testId <= numberOfTests; ++testId) {
            if (tests[testId]) continue;
            mXparser.consolePrintln("ERROR: " + testId);
        }
        return nError;
    }

    public static void main(String[] args) {
        RegTestSyntax.start();
    }
}

