/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class OkPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(OkPacket.class);
    private final long affectedRows;
    private final long lastInsertId;

    public OkPacket(ReadableByteBuf buf, Context context) {
        buf.skip();
        this.affectedRows = buf.readLongLengthEncodedNotNull();
        this.lastInsertId = buf.readLongLengthEncodedNotNull();
        context.setServerStatus(buf.readUnsignedShort());
        context.setWarning(buf.readUnsignedShort());
        if (buf.readableBytes() > 0 && context.hasClientCapability(0x800000L)) {
            buf.skip(buf.readIntLengthEncodedNotNull());
            while (buf.readableBytes() > 0) {
                ReadableByteBuf sessionStateBuf = buf.readLengthBuffer();
                block17: while (sessionStateBuf.readableBytes() > 0) {
                    switch (sessionStateBuf.readByte()) {
                        case 0: {
                            ReadableByteBuf tmpBufsv;
                            do {
                                tmpBufsv = sessionStateBuf.readLengthBuffer();
                                String variableSv = tmpBufsv.readString(tmpBufsv.readIntLengthEncodedNotNull());
                                Integer lenSv = tmpBufsv.readLength();
                                String valueSv = lenSv == null ? null : tmpBufsv.readString(lenSv);
                                logger.debug("System variable change:  {} = {}", variableSv, valueSv);
                                switch (variableSv) {
                                    case "character_set_client": {
                                        context.setCharset(valueSv);
                                        break;
                                    }
                                    case "connection_id": {
                                        context.setThreadId(Long.parseLong(valueSv));
                                        break;
                                    }
                                    case "threads_Connected": {
                                        context.setTreadsConnected(Long.parseLong(valueSv));
                                        break;
                                    }
                                    case "auto_increment_increment": {
                                        context.setAutoIncrement(Long.parseLong(valueSv));
                                    }
                                }
                            } while (tmpBufsv.readableBytes() > 0);
                            continue block17;
                        }
                        case 1: {
                            sessionStateBuf.readIntLengthEncodedNotNull();
                            Integer dbLen = sessionStateBuf.readLength();
                            String database = dbLen == null || dbLen == 0 ? null : sessionStateBuf.readString(dbLen);
                            context.setDatabase(database);
                            logger.debug("Database change: is '{}'", database);
                            continue block17;
                        }
                    }
                    buf.skip(buf.readIntLengthEncodedNotNull());
                }
            }
        }
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }
}

