/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.util.CharsetEncodingLength;

public class UuidColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public UuidColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return conf.uuidAsString() ? String.class.getName() : UUID.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return conf.uuidAsString() ? 1 : 1111;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "uuid";
    }

    @Override
    public int getPrecision() {
        Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
        if (maxWidth == null) {
            return (int)this.columnLength;
        }
        return (int)(this.columnLength / (long)maxWidth.intValue());
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return conf.uuidAsString() ? buf.readString(length) : UUID.fromString(buf.readAscii(length));
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return conf.uuidAsString() ? buf.readString(length) : UUID.fromString(buf.readAscii(length));
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Boolean");
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Boolean");
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as byte");
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as byte");
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        return buf.readString(length);
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Short");
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Short");
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Integer");
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Integer");
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Long");
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Long");
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Float");
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Float");
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Double");
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, int length) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Double");
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Date");
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Date");
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Time");
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Time");
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Timestamp");
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar calParam) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException("Data type UUID cannot be decoded as Timestamp");
    }
}

