/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.pool.MariaDbInnerPoolConnection;
import org.mariadb.jdbc.pool.Pool;
import org.mariadb.jdbc.pool.Pools;

public class MariaDbPoolDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Closeable,
AutoCloseable {
    private final Pool pool;

    public MariaDbPoolDataSource(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong mariaDB url: %s", url));
        }
        Configuration conf = Configuration.parse(url);
        this.pool = Pools.retrievePool(conf);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.pool.getPoolConnection().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.pool.getPoolConnection(username, password).getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Datasource is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        return this.pool.getConf().connectTimeout() / 1000;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        this.pool.getConf().connectTimeout(seconds * 1000);
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public MariaDbInnerPoolConnection getPooledConnection() throws SQLException {
        return this.pool.getPoolConnection();
    }

    @Override
    public MariaDbInnerPoolConnection getPooledConnection(String username, String password) throws SQLException {
        return this.pool.getPoolConnection(username, password);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.pool.getPoolConnection();
    }

    @Override
    public XAConnection getXAConnection(String username, String password) throws SQLException {
        return this.pool.getPoolConnection(username, password);
    }

    @Override
    public void close() {
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPoolName() {
        return this.pool.getPoolTag();
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        return this.pool.testGetConnectionIdleThreadIds();
    }
}

