/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.socket;

import com.sun.jna.Platform;
import java.io.IOException;
import org.mariadb.jdbc.internal.io.socket.NamedPipeSocket;
import org.mariadb.jdbc.internal.io.socket.SharedMemorySocket;
import org.mariadb.jdbc.internal.io.socket.SocketHandlerFunction;
import org.mariadb.jdbc.internal.io.socket.UnixDomainSocket;
import org.mariadb.jdbc.internal.util.Utils;

public class SocketUtility {
    public static SocketHandlerFunction getSocketHandler() {
        try {
            Platform.getOSType();
            return (urlParser, host) -> {
                if (urlParser.getOptions().pipe != null) {
                    return new NamedPipeSocket(host, urlParser.getOptions().pipe);
                }
                if (urlParser.getOptions().localSocket != null) {
                    try {
                        return new UnixDomainSocket(urlParser.getOptions().localSocket);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                if (urlParser.getOptions().sharedMemory != null) {
                    try {
                        return new SharedMemorySocket(urlParser.getOptions().sharedMemory);
                    }
                    catch (RuntimeException re) {
                        throw new IOException(re.getMessage(), re.getCause());
                    }
                }
                return Utils.standardSocket(urlParser, host);
            };
        }
        catch (Throwable throwable) {
            return (urlParser, host) -> Utils.standardSocket(urlParser, host);
        }
    }
}

