/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class TextRowProtocol
extends RowProtocol {
    public TextRowProtocol(int maxFieldSize, Options options) {
        super(maxFieldSize, options);
    }

    @Override
    public void setPosition(int newIndex) {
        if (this.index != newIndex) {
            if (this.index == -1 || this.index > newIndex) {
                this.pos = 0;
                this.index = 0;
            } else {
                ++this.index;
                if (this.length != -1) {
                    this.pos += this.length;
                }
            }
            while (this.index <= newIndex) {
                int type;
                if (this.index != newIndex) {
                    type = this.buf[this.pos++] & 0xFF;
                    switch (type) {
                        case 251: {
                            break;
                        }
                        case 252: {
                            this.pos += 2 + (0xFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8));
                            break;
                        }
                        case 253: {
                            this.pos += 3 + (0xFFFFFF & (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16));
                            break;
                        }
                        case 254: {
                            this.pos = (int)((long)this.pos + (8L + ((long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56))));
                            break;
                        }
                        default: {
                            this.pos += type;
                            break;
                        }
                    }
                } else {
                    type = this.buf[this.pos++] & 0xFF;
                    switch (type) {
                        case 251: {
                            this.length = -1;
                            this.lastValueNull = 1;
                            return;
                        }
                        case 252: {
                            this.length = 0xFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8);
                            break;
                        }
                        case 253: {
                            this.length = 0xFFFFFF & (this.buf[this.pos++] & 0xFF) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 16);
                            break;
                        }
                        case 254: {
                            this.length = (int)((long)(this.buf[this.pos++] & 0xFF) + ((long)(this.buf[this.pos++] & 0xFF) << 8) + ((long)(this.buf[this.pos++] & 0xFF) << 16) + ((long)(this.buf[this.pos++] & 0xFF) << 24) + ((long)(this.buf[this.pos++] & 0xFF) << 32) + ((long)(this.buf[this.pos++] & 0xFF) << 40) + ((long)(this.buf[this.pos++] & 0xFF) << 48) + ((long)(this.buf[this.pos++] & 0xFF) << 56));
                            break;
                        }
                        default: {
                            this.length = type;
                        }
                    }
                    this.lastValueNull = 0;
                    return;
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case DOUBLE: 
            case FLOAT: {
                return this.zeroFillingIfNeeded(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8), columnInfo);
            }
            case TIME: {
                return this.getInternalTimeString(columnInfo);
            }
            case DATE: {
                Date date = this.getInternalDate(columnInfo, cal, timeZone);
                if (date == null) {
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return date.toString();
            }
            case YEAR: {
                if (!this.options.yearIsDateType) break;
                Date date1 = this.getInternalDate(columnInfo, cal, timeZone);
                return date1 == null ? null : date1.toString();
            }
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
                if (timestamp == null) {
                    if ((this.lastValueNull & 2) != 0) {
                        this.lastValueNull ^= 2;
                        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    }
                    return null;
                }
                return timestamp.toString();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                return bigDecimal == null ? null : this.zeroFillingIfNeeded(bigDecimal.toString(), columnInfo);
            }
            case NULL: {
                return null;
            }
        }
        if (this.maxFieldSize > 0) {
            return new String(this.buf, this.pos, Math.max(this.maxFieldSize * 3, this.length), StandardCharsets.UTF_8).substring(0, this.maxFieldSize);
        }
        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public int getInternalInt(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long value = this.getInternalLong(columnInfo);
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value, columnInfo);
        return (int)value;
    }

    @Override
    public long getInternalLong(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0L;
        }
        try {
            switch (columnInfo.getColumnType()) {
                case FLOAT: {
                    Float floatValue = Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                    if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return floatValue.longValue();
                }
                case DOUBLE: {
                    Double doubleValue = Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                    if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + " is not in Long range", "22003", 1264);
                    }
                    return doubleValue.longValue();
                }
                case BIT: {
                    return this.parseBit();
                }
                case YEAR: 
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case MEDIUMINT: 
                case BIGINT: {
                    long result = 0L;
                    boolean negate = false;
                    int begin = this.pos;
                    if (this.length > 0 && this.buf[begin] == 45) {
                        negate = true;
                        ++begin;
                    }
                    while (begin < this.pos + this.length) {
                        result = result * 10L + (long)this.buf[begin] - 48L;
                        ++begin;
                    }
                    if (result < 0L) {
                        if (result == Long.MIN_VALUE && negate) {
                            return Long.MIN_VALUE;
                        }
                        throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' for value " + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8), "22003", 1264);
                    }
                    return negate ? -1L * result : result;
                }
            }
            return Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
        }
        catch (NumberFormatException nfe) {
            String value = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            if (isIntegerRegex.matcher(value).find()) {
                try {
                    return Long.parseLong(value.substring(0, value.indexOf(".")));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value, "22003", 1264);
        }
    }

    @Override
    public float getInternalFloat(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case DOUBLE: 
            case FLOAT: 
            case YEAR: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                try {
                    return Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8)).floatValue();
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "\" for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
        }
        throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
    }

    @Override
    public double getInternalDouble(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case DOUBLE: 
            case FLOAT: 
            case YEAR: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case MEDIUMINT: 
            case BIGINT: 
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                try {
                    return Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format \"" + new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8) + "\" for getDouble for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
        }
        throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.BIT) {
            return BigDecimal.valueOf(this.parseBit());
        }
        return new BigDecimal(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public Date getInternalDate(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        String rawValue = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
                if (timestamp == null) {
                    return null;
                }
                return new Date(timestamp.getTime());
            }
            case TIME: {
                throw new SQLException("Cannot read DATE using a Types.TIME field");
            }
            case DATE: {
                if ("0000-00-00".equals(rawValue)) {
                    this.lastValueNull |= 2;
                    return null;
                }
                return new Date(Integer.parseInt(rawValue.substring(0, 4)) - 1900, Integer.parseInt(rawValue.substring(5, 7)) - 1, Integer.parseInt(rawValue.substring(8, 10)));
            }
            case YEAR: {
                int year = Integer.parseInt(rawValue);
                if (this.length == 2 && columnInfo.getLength() == 2L) {
                    year = year <= 69 ? (year += 2000) : (year += 1900);
                }
                return new Date(year - 1900, 0, 1);
            }
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(timeZone);
            java.util.Date utilDate = sdf.parse(rawValue);
            return new Date(utilDate.getTime());
        }
        catch (ParseException e) {
            throw ExceptionMapper.getSqlException("Could not get object as Date : " + e.getMessage(), "S1009", e);
        }
    }

    @Override
    public Time getInternalTime(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        String[] rawPart;
        if (this.lastValueWasNull()) {
            return null;
        }
        if (columnInfo.getColumnType() == ColumnType.TIMESTAMP || columnInfo.getColumnType() == ColumnType.DATETIME) {
            Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
            return timestamp == null ? null : new Time(timestamp.getTime());
        }
        if (columnInfo.getColumnType() == ColumnType.DATE) {
            throw new SQLException("Cannot read Time using a Types.DATE field");
        }
        String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if (!this.options.useLegacyDatetimeCode && (raw.startsWith("-") || raw.split(":").length != 3 || raw.indexOf(":") > 3)) {
            throw new SQLException("Time format \"" + raw + "\" incorrect, must be HH:mm:ss");
        }
        boolean negate = raw.startsWith("-");
        if (negate) {
            raw = raw.substring(1);
        }
        if ((rawPart = raw.split(":")).length == 3) {
            int hour = Integer.parseInt(rawPart[0]);
            int minutes = Integer.parseInt(rawPart[1]);
            int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
            Calendar calendar = Calendar.getInstance();
            if (this.options.useLegacyDatetimeCode) {
                calendar.setLenient(true);
            }
            calendar.clear();
            calendar.set(1970, 0, 1, (negate ? -1 : 1) * hour, minutes, seconds);
            int nanoseconds = this.extractNanos(raw);
            calendar.set(14, nanoseconds / 1000000);
            return new Time(calendar.getTimeInMillis());
        }
        throw new SQLException(raw + " cannot be parse as time. time must have \"99:99:99\" format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getInternalTimestamp(ColumnInformation columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        String rawValue = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if (rawValue.startsWith("0000-00-00 00:00:00")) {
            this.lastValueNull |= 2;
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case TIME: {
                Timestamp tt = new Timestamp(this.getInternalTime(columnInfo, userCalendar, timeZone).getTime());
                tt.setNanos(this.extractNanos(rawValue));
                return tt;
            }
        }
        try {
            Timestamp timestamp;
            int hour = 0;
            int minutes = 0;
            int seconds = 0;
            int year = Integer.parseInt(rawValue.substring(0, 4));
            int month = Integer.parseInt(rawValue.substring(5, 7));
            int day = Integer.parseInt(rawValue.substring(8, 10));
            if (rawValue.length() >= 19) {
                hour = Integer.parseInt(rawValue.substring(11, 13));
                minutes = Integer.parseInt(rawValue.substring(14, 16));
                seconds = Integer.parseInt(rawValue.substring(17, 19));
            }
            int nanoseconds = this.extractNanos(rawValue);
            Calendar calendar = userCalendar != null ? userCalendar : (columnInfo.getColumnType().getSqlType() == 93 ? Calendar.getInstance(timeZone) : Calendar.getInstance());
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.clear();
                calendar.set(1, year);
                calendar.set(2, month - 1);
                calendar.set(5, day);
                calendar.set(11, hour);
                calendar.set(12, minutes);
                calendar.set(13, seconds);
                calendar.set(14, nanoseconds / 1000000);
                timestamp = new Timestamp(calendar.getTime().getTime());
            }
            timestamp.setNanos(nanoseconds);
            return timestamp;
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException n) {
            throw new SQLException("Value \"" + rawValue + "\" cannot be parse as Timestamp");
        }
    }

    @Override
    public Object getInternalObject(ColumnInformation columnInfo, int dataTypeMappingFlags, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                byte[] dataBit = new byte[this.length];
                System.arraycopy(this.buf, this.pos, dataBit, 0, this.length);
                return dataBit;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 48;
                }
                return this.getInternalInt(columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalLong(columnInfo);
                }
                return this.getInternalInt(columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalBigInteger(columnInfo);
                }
                return this.getInternalLong(columnInfo);
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo);
            }
            case VARCHAR: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getInternalTimestamp(columnInfo, null, timeZone);
            }
            case DATE: {
                return this.getInternalDate(columnInfo, null, timeZone);
            }
            case DECIMAL: {
                return this.getInternalBigDecimal(columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                byte[] dataBlob = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, dataBlob, 0, this.getLengthMaxFieldSize());
                return dataBlob;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((dataTypeMappingFlags & 2) != 0) {
                    return this.getInternalDate(columnInfo, null, timeZone);
                }
                return this.getInternalShort(columnInfo);
            }
            case SMALLINT: 
            case MEDIUMINT: {
                return this.getInternalInt(columnInfo);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat(columnInfo));
            }
            case TIME: {
                return this.getInternalTime(columnInfo, null, timeZone);
            }
            case VARSTRING: 
            case STRING: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case OLDDECIMAL: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case GEOMETRY: {
                byte[] data = new byte[this.length];
                System.arraycopy(this.buf, this.pos, data, 0, this.length);
                return data;
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw ExceptionMapper.getFeatureNotSupportedException("Type '" + columnInfo.getColumnType().getTypeName() + "' is not supported");
    }

    @Override
    public boolean getInternalBoolean(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return false;
        }
        if (columnInfo.getColumnType() == ColumnType.BIT) {
            return this.parseBit() != 0L;
        }
        String rawVal = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        return !"false".equals(rawVal) && !"0".equals(rawVal);
    }

    @Override
    public byte getInternalByte(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long value = this.getInternalLong(columnInfo);
        this.rangeCheck(Byte.class, -128L, 127L, value, columnInfo);
        return (byte)value;
    }

    @Override
    public short getInternalShort(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0;
        }
        long value = this.getInternalLong(columnInfo);
        this.rangeCheck(Short.class, -32768L, 32767L, value, columnInfo);
        return (short)value;
    }

    @Override
    public String getInternalTimeString(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        String rawValue = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        if (this.options.maximizeMysqlCompatibility && this.options.useLegacyDatetimeCode && rawValue.indexOf(".") > 0) {
            return rawValue.substring(0, rawValue.indexOf("."));
        }
        return rawValue;
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnInformation columnInfo, Class clazz, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (columnInfo.getColumnType().getSqlType()) {
            case 93: {
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    LocalDateTime localDateTime = LocalDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(timeZone.toZoneId()));
                    return ZonedDateTime.of(localDateTime, timeZone.toZoneId());
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDateTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                }
            }
            case -1: 
            case 1: 
            case 12: {
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(raw, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = timeZone.toZoneId().normalized();
        if (ZoneOffset.class.isInstance(zoneId)) {
            ZoneOffset zoneOffset = (ZoneOffset)ZoneOffset.class.cast(zoneId);
            String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    if (raw.startsWith("0000-00-00 00:00:00")) {
                        return null;
                    }
                    try {
                        return ZonedDateTime.parse(raw, TEXT_LOCAL_DATE_TIME.withZone(zoneOffset)).toOffsetDateTime().toOffsetTime();
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime. time must have \"yyyy-MM-dd HH:mm:ss[.S]\" format");
                    }
                }
                case 92: {
                    try {
                        LocalTime localTime = LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(zoneOffset));
                        return OffsetTime.of(localTime, zoneOffset);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (columnInfo.getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 92: {
                try {
                    return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalTime.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        switch (columnInfo.getColumnType().getSqlType()) {
            case -1: 
            case 1: 
            case 12: 
            case 91: {
                if (raw.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDate (format is \"yyyy-MM-dd\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalDate.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public boolean isBinaryEncoded() {
        return false;
    }
}

