/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;

public class LogQueryTool {
    private final Options options;

    public LogQueryTool(Options options) {
        this.options = options;
    }

    public String subQuery(String sql) {
        if (this.options.maxQuerySizeToLog > 0 && sql.length() > this.options.maxQuerySizeToLog - 3) {
            return sql.substring(0, this.options.maxQuerySizeToLog - 3) + "...";
        }
        return sql;
    }

    private String subQuery(ByteBuffer buffer) {
        String queryString;
        if (this.options.maxQuerySizeToLog == 0) {
            queryString = new String(buffer.array(), 5, buffer.limit());
        } else {
            queryString = new String(buffer.array(), 5, Math.min(buffer.limit() - 5, this.options.maxQuerySizeToLog * 3));
            if (queryString.length() > this.options.maxQuerySizeToLog - 3) {
                queryString = queryString.substring(0, this.options.maxQuerySizeToLog - 3) + "...";
            }
        }
        return queryString;
    }

    public SQLException exceptionWithQuery(String sql, SQLException sqlException) {
        if (this.options.dumpQueriesOnException || sqlException.getErrorCode() == 1064) {
            return new SQLException(sqlException.getMessage() + "\nQuery is: " + this.subQuery(sql), sqlException.getSQLState(), sqlException.getErrorCode(), sqlException.getCause());
        }
        return sqlException;
    }

    public SQLException exceptionWithQuery(ByteBuffer buffer, SQLException sqlEx) {
        if (this.options.dumpQueriesOnException || sqlEx.getErrorCode() == 1064) {
            return this.exceptionWithQuery(this.subQuery(buffer), sqlEx);
        }
        return sqlEx;
    }

    public SQLException exceptionWithQuery(ParameterHolder[] parameters, SQLException sqlEx, PrepareResult serverPrepareResult) {
        if (sqlEx.getCause() instanceof SocketTimeoutException) {
            return new SQLException("Connection timed out", SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqlEx);
        }
        if (this.options.dumpQueriesOnException) {
            return new SQLException(this.exWithQuery(sqlEx.getMessage(), serverPrepareResult, parameters), sqlEx.getSQLState(), sqlEx.getErrorCode(), sqlEx.getCause());
        }
        return sqlEx;
    }

    public SQLException exceptionWithQuery(SQLException sqlEx, PrepareResult prepareResult) {
        if (this.options.dumpQueriesOnException || sqlEx.getErrorCode() == 1064) {
            String querySql = prepareResult.getSql();
            String message = sqlEx.getMessage();
            message = this.options.maxQuerySizeToLog != 0 && querySql.length() > this.options.maxQuerySizeToLog - 3 ? message + "\nQuery is: " + querySql.substring(0, this.options.maxQuerySizeToLog - 3) + "..." : message + "\nQuery is: " + querySql;
            return new SQLException(message, sqlEx.getSQLState(), sqlEx.getErrorCode(), sqlEx.getCause());
        }
        return sqlEx;
    }

    private String exWithQuery(String message, PrepareResult serverPrepareResult, ParameterHolder[] parameters) {
        if (this.options.dumpQueriesOnException) {
            StringBuilder sql = new StringBuilder(serverPrepareResult.getSql());
            if (serverPrepareResult.getParamCount() > 0) {
                sql.append(", parameters [");
                if (parameters.length > 0) {
                    for (int i = 0; i < Math.min(parameters.length, serverPrepareResult.getParamCount()); ++i) {
                        sql.append(parameters[i].toString()).append(",");
                    }
                    sql = new StringBuilder(sql.substring(0, sql.length() - 1));
                }
                sql.append("]");
            }
            if (this.options.maxQuerySizeToLog != 0 && sql.length() > this.options.maxQuerySizeToLog - 3) {
                return message + "\nQuery is: " + sql.substring(0, this.options.maxQuerySizeToLog - 3) + "...";
            }
            return message + "\nQuery is: " + sql;
        }
        return message;
    }
}

