/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.failover.FailoverProxy;
import org.mariadb.jdbc.internal.failover.impl.AuroraListener;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.protocol.MastersSlavesProtocol;
import org.mariadb.jdbc.internal.util.SqlStates;

public class AuroraProtocol
extends MastersSlavesProtocol {
    public AuroraProtocol(UrlParser url, ReentrantLock lock) {
        super(url, lock);
    }

    public static void searchProbableMaster(AuroraListener listener, HostAddress probableMaster) {
        AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
        try {
            protocol.setHostAddress(probableMaster);
            protocol.connect();
            listener.removeFromBlacklist(protocol.getHostAddress());
            if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                protocol.setMustBeMasterConnection(true);
                listener.foundActiveMaster(protocol);
            } else if (listener.isSecondaryHostFailReconnect() && !protocol.isMasterConnection()) {
                protocol.setMustBeMasterConnection(false);
                listener.foundActiveSecondary(protocol);
            } else {
                protocol.close();
                protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            }
        }
        catch (SQLException e) {
            listener.addToBlacklist(protocol.getHostAddress());
        }
    }

    public static void loop(AuroraListener listener, List<HostAddress> addresses, SearchFilter searchFilter) throws SQLException {
        ArrayDeque<HostAddress> loopAddresses = new ArrayDeque<HostAddress>(addresses);
        if (loopAddresses.isEmpty()) {
            AuroraProtocol.resetHostList(listener, loopAddresses);
        }
        int maxConnectionTry = listener.getRetriesAllDown();
        SQLException lastQueryException = null;
        HostAddress probableMasterHost = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
            AuroraProtocol protocol = AuroraProtocol.getNewProtocol(listener.getProxy(), listener.getUrlParser());
            if (listener.isExplicitClosed() || !listener.isSecondaryHostFailReconnect() && !listener.isMasterHostFailReconnect()) {
                return;
            }
            --maxConnectionTry;
            try {
                HostAddress host = (HostAddress)loopAddresses.pollFirst();
                if (host == null) {
                    for (HostAddress hostAddress : listener.getUrlParser().getHostAddresses()) {
                        if (hostAddress.equals(listener.getClusterHostAddress())) continue;
                        loopAddresses.add(hostAddress);
                    }
                    if (listener.getClusterHostAddress() != null && listener.getUrlParser().getHostAddresses().size() < 2) {
                        loopAddresses.add(listener.getClusterHostAddress());
                    }
                    host = (HostAddress)loopAddresses.pollFirst();
                }
                protocol.setHostAddress(host);
                protocol.connect();
                if (listener.isExplicitClosed()) {
                    protocol.close();
                    return;
                }
                listener.removeFromBlacklist(protocol.getHostAddress());
                if (listener.isMasterHostFailReconnect() && protocol.isMasterConnection()) {
                    if (searchFilter.isFineIfFoundOnlyMaster() && listener.getUrlParser().getHostAddresses().size() <= 1 && protocol.getHostAddress().equals(listener.getClusterHostAddress())) {
                        listener.retrieveAllEndpointsAndSet(protocol);
                        if (listener.getUrlParser().getHostAddresses().size() > 1) {
                            loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                            searchFilter = new SearchFilter(false);
                        }
                    }
                    if (AuroraProtocol.foundMaster(listener, protocol, searchFilter)) {
                        return;
                    }
                } else if (!protocol.isMasterConnection()) {
                    if (listener.isSecondaryHostFailReconnect()) {
                        if (listener.getUrlParser().getHostAddresses().size() <= 1 && protocol.getHostAddress().equals(listener.getClusterHostAddress())) {
                            listener.retrieveAllEndpointsAndSet(protocol);
                            if (listener.getUrlParser().getHostAddresses().size() > 1) {
                                loopAddresses.addAll(listener.getUrlParser().getHostAddresses());
                                searchFilter = new SearchFilter(false);
                            }
                        } else if (AuroraProtocol.foundSecondary(listener, protocol, searchFilter)) {
                            return;
                        }
                    }
                    if ((listener.isSecondaryHostFailReconnect() || listener.isMasterHostFailReconnect() && probableMasterHost == null) && (probableMasterHost = listener.searchByStartName(protocol, listener.getUrlParser().getHostAddresses())) != null) {
                        loopAddresses.remove(probableMasterHost);
                        AuroraProtocol.searchProbableMaster(listener, probableMasterHost);
                        if (listener.isMasterHostFailReconnect() && searchFilter.isFineIfFoundOnlySlave()) {
                            return;
                        }
                    }
                } else {
                    protocol.close();
                }
            }
            catch (SQLException e) {
                lastQueryException = e;
                listener.addToBlacklist(protocol.getHostAddress());
            }
            if (!listener.isMasterHostFailReconnect() && !listener.isSecondaryHostFailReconnect()) {
                return;
            }
            if (loopAddresses.isEmpty() && !searchFilter.isFailoverLoop() && maxConnectionTry > 0) {
                AuroraProtocol.resetHostList(listener, loopAddresses);
            }
            if (maxConnectionTry != 0 || loopAddresses.contains(listener.getClusterHostAddress()) || listener.getClusterHostAddress() == null) continue;
            loopAddresses.add(listener.getClusterHostAddress());
        }
        if (listener.isMasterHostFailReconnect() || listener.isSecondaryHostFailReconnect()) {
            String error = "No active connection found for replica";
            if (listener.isMasterHostFailReconnect()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new SQLException(error, lastQueryException.getSQLState(), lastQueryException.getErrorCode(), lastQueryException);
            }
            throw new SQLException(error);
        }
    }

    private static void resetHostList(AuroraListener listener, Deque<HostAddress> loopAddresses) {
        ArrayList<HostAddress> servers = new ArrayList<HostAddress>();
        servers.addAll(listener.getUrlParser().getHostAddresses());
        Collections.shuffle(servers);
        if (listener.getClusterHostAddress() != null && listener.getUrlParser().getHostAddresses().size() < 2) {
            servers.add(listener.getClusterHostAddress());
        }
        servers.removeAll(listener.connectedHosts());
        loopAddresses.clear();
        loopAddresses.addAll(loopAddresses);
    }

    public static AuroraProtocol getNewProtocol(FailoverProxy proxy, UrlParser urlParser) {
        AuroraProtocol newProtocol = new AuroraProtocol(urlParser, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean isMasterConnection() {
        return this.masterConnection;
    }

    @Override
    public void readPipelineCheckMaster() throws IOException, SQLException {
        Results results = new Results();
        this.getResult(results);
        results.commandEnd();
        SelectResultSet resultSet = results.getResultSet();
        if (!resultSet.next()) {
            throw new SQLException("Error checking Aurora's master status : No information");
        }
        this.masterConnection = "OFF".equals(resultSet.getString(2));
        this.reader.setServerThreadId(this.serverThreadId, this.masterConnection);
        this.writer.setServerThreadId(this.serverThreadId, this.masterConnection);
        this.readOnly = !this.masterConnection;
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.isMasterConnection()) {
            return this.checkIfMaster();
        }
        return this.ping();
    }

    @Override
    public boolean checkIfMaster() throws SQLException {
        this.proxy.lock.lock();
        try {
            Results results = new Results();
            this.executeQuery(this.isMasterConnection(), results, "show global variables like 'innodb_read_only'");
            results.commandEnd();
            SelectResultSet queryResult = results.getResultSet();
            if (queryResult != null) {
                queryResult.next();
                this.masterConnection = "OFF".equals(queryResult.getString(2));
                this.reader.setServerThreadId(this.serverThreadId, this.masterConnection);
                this.writer.setServerThreadId(this.serverThreadId, this.masterConnection);
            } else {
                this.masterConnection = false;
            }
            this.readOnly = !this.masterConnection;
            boolean bl = this.masterConnection;
            return bl;
        }
        catch (SQLException sqle) {
            throw new SQLException("could not check the 'innodb_read_only' variable status on " + this.getHostAddress() + " : " + sqle.getMessage(), SqlStates.CONNECTION_EXCEPTION.getSqlState(), sqle);
        }
        finally {
            this.proxy.lock.unlock();
        }
    }
}

