/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.failover;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.failover.AbstractMastersListener;
import org.mariadb.jdbc.internal.failover.HandleErrorResult;
import org.mariadb.jdbc.internal.failover.tools.SearchFilter;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;

public abstract class AbstractMastersSlavesListener
extends AbstractMastersListener {
    private static Logger logger = LoggerFactory.getLogger(AbstractMastersSlavesListener.class);
    protected AtomicReference<Protocol> waitNewSecondaryProtocol = new AtomicReference();
    protected AtomicReference<Protocol> waitNewMasterProtocol = new AtomicReference();
    private volatile long secondaryHostFailNanos = 0L;
    private AtomicBoolean secondaryHostFail = new AtomicBoolean();

    protected AbstractMastersSlavesListener(UrlParser urlParser) {
        super(urlParser);
        this.secondaryHostFail.set(true);
    }

    @Override
    public HandleErrorResult handleFailover(SQLException qe, Method method, Object[] args, Protocol protocol) throws Throwable {
        boolean killCmd;
        if (this.isExplicitClosed()) {
            throw new SQLException("Connection has been closed !");
        }
        boolean bl = killCmd = qe != null && qe.getSQLState() != null && qe.getSQLState().equals("70100") && 1927 == qe.getErrorCode();
        if (protocol.mustBeMasterConnection()) {
            if (!protocol.isMasterConnection()) {
                logger.warn("SQL Primary node [" + this.currentProtocol.getHostAddress().toString() + ", conn " + this.currentProtocol.getServerThreadId() + " ] is now in read-only mode. Exception : " + qe.getMessage());
            } else if (this.setMasterHostFail()) {
                logger.warn("SQL Primary node [" + this.currentProtocol.getHostAddress().toString() + ", conn " + this.currentProtocol.getServerThreadId() + " ] connection fail. Reason : " + qe.getMessage());
                this.addToBlacklist(protocol.getHostAddress());
            }
            return this.primaryFail(method, args, killCmd);
        }
        if (this.setSecondaryHostFail()) {
            logger.warn("SQL secondary node [" + this.currentProtocol.getHostAddress().toString() + ", conn " + this.currentProtocol.getServerThreadId() + " ] connection fail. Reason : " + qe.getMessage());
            this.addToBlacklist(protocol.getHostAddress());
        }
        return this.secondaryFail(method, args, killCmd);
    }

    @Override
    protected void resetMasterFailoverData() {
        super.resetMasterFailoverData();
        if (!this.secondaryHostFail.get()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    protected void resetSecondaryFailoverData() {
        if (this.secondaryHostFail.compareAndSet(true, false)) {
            this.secondaryHostFailNanos = 0L;
        }
        if (!this.isMasterHostFail()) {
            this.currentConnectionAttempts.set(0);
            this.lastRetry = 0L;
        }
    }

    public long getSecondaryHostFailNanos() {
        return this.secondaryHostFailNanos;
    }

    public boolean setSecondaryHostFail() {
        if (this.secondaryHostFail.compareAndSet(false, true)) {
            this.secondaryHostFailNanos = System.nanoTime();
            this.currentConnectionAttempts.set(0);
            return true;
        }
        return false;
    }

    public boolean isSecondaryHostFail() {
        return this.secondaryHostFail.get();
    }

    public boolean isSecondaryHostFailReconnect() {
        return this.secondaryHostFail.get() && this.waitNewSecondaryProtocol.get() == null;
    }

    public boolean isMasterHostFailReconnect() {
        return this.isMasterHostFail() && this.waitNewMasterProtocol.get() == null;
    }

    @Override
    public boolean hasHostFail() {
        return this.isSecondaryHostFailReconnect() || this.isMasterHostFailReconnect();
    }

    @Override
    public SearchFilter getFilterForFailedHost() {
        return new SearchFilter(this.isMasterHostFail(), this.isSecondaryHostFail());
    }

    public abstract HandleErrorResult secondaryFail(Method var1, Object[] var2, boolean var3) throws Throwable;

    public abstract void foundActiveSecondary(Protocol var1) throws SQLException;
}

