/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public enum ColumnType {
    OLDDECIMAL(0, 3, "Types.DECIMAL", BigDecimal.class.getName()),
    TINYINT(1, 5, "Types.SMALLINT", Integer.class.getName()),
    SMALLINT(2, 5, "Types.SMALLINT", Integer.class.getName()),
    INTEGER(3, 4, "Types.INTEGER", Integer.class.getName()),
    FLOAT(4, 7, "Types.REAL", Float.class.getName()),
    DOUBLE(5, 8, "Types.DOUBLE", Double.class.getName()),
    NULL(6, 0, "Types.NULL", String.class.getName()),
    TIMESTAMP(7, 93, "Types.TIMESTAMP", Timestamp.class.getName()),
    BIGINT(8, -5, "Types.BIGINT", Long.class.getName()),
    MEDIUMINT(9, 4, "Types.INTEGER", Integer.class.getName()),
    DATE(10, 91, "Types.DATE", Date.class.getName()),
    TIME(11, 92, "Types.TIME", Time.class.getName()),
    DATETIME(12, 93, "Types.TIMESTAMP", Timestamp.class.getName()),
    YEAR(13, 5, "Types.SMALLINT", Short.class.getName()),
    NEWDATE(14, 91, "Types.DATE", Date.class.getName()),
    VARCHAR(15, 12, "Types.VARCHAR", String.class.getName()),
    BIT(16, -7, "Types.BIT", "[B"),
    DECIMAL(246, 3, "Types.DECIMAL", BigDecimal.class.getName()),
    ENUM(247, 12, "Types.VARCHAR", String.class.getName()),
    SET(248, 12, "Types.VARCHAR", String.class.getName()),
    TINYBLOB(249, -3, "Types.VARBINARY", "[B"),
    MEDIUMBLOB(250, -3, "Types.VARBINARY", "[B"),
    LONGBLOB(251, -4, "Types.LONGVARBINARY", "[B"),
    BLOB(252, -4, "Types.LONGVARBINARY", "[B"),
    VARSTRING(253, 12, "Types.VARCHAR", String.class.getName()),
    STRING(254, 12, "Types.VARCHAR", String.class.getName()),
    GEOMETRY(255, -3, "Types.VARBINARY", "[B");

    static ColumnType[] typeMap;
    private final short mysqlType;
    private final int javaType;
    private final String javaTypeName;
    private final String className;

    private ColumnType(int mysqlType, int javaType, String javaTypeName, String className) {
        this.mysqlType = (short)mysqlType;
        this.javaType = javaType;
        this.javaTypeName = javaTypeName;
        this.className = className;
    }

    public static Class classFromJavaType(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 91: {
                return Date.class;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2004: {
                return byte[].class;
            }
            case 0: {
                return null;
            }
            case 92: {
                return Time.class;
            }
        }
        return null;
    }

    public static boolean isNumeric(ColumnType type) {
        switch (type) {
            case OLDDECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BIGINT: 
            case MEDIUMINT: 
            case BIT: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public static String getColumnTypeName(ColumnType type, long len, boolean signed, boolean binary) {
        switch (type) {
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case MEDIUMINT: {
                if (!signed) {
                    return type.getTypeName() + " UNSIGNED";
                }
                return type.getTypeName();
            }
            case BLOB: {
                if (len < 0L) {
                    return "LONGBLOB";
                }
                if (len <= 255L) {
                    return "TINYBLOB";
                }
                if (len <= 65535L) {
                    return "BLOB";
                }
                if (len <= 0xFFFFFFL) {
                    return "MEDIUMBLOB";
                }
                return "LONGBLOB";
            }
            case VARSTRING: 
            case VARCHAR: {
                if (binary) {
                    return "VARBINARY";
                }
                return "VARCHAR";
            }
            case STRING: {
                if (binary) {
                    return "BINARY";
                }
                return "CHAR";
            }
        }
        return type.getTypeName();
    }

    public static ColumnType fromServer(int typeValue) {
        ColumnType columnType = typeMap[typeValue];
        if (columnType == null) {
            columnType = BLOB;
        }
        return columnType;
    }

    public static ColumnType toServer(int javaType) {
        for (ColumnType v : ColumnType.values()) {
            if (v.javaType != javaType) continue;
            return v;
        }
        return BLOB;
    }

    public static String getClassName(ColumnType type, int len, boolean signed, boolean binary, int flags) {
        switch (type) {
            case TINYINT: {
                if (len == 1 && (flags & 1) != 0) {
                    return Boolean.class.getName();
                }
                return Integer.class.getName();
            }
            case INTEGER: {
                return signed ? Integer.class.getName() : Long.class.getName();
            }
            case BIGINT: {
                return signed ? Long.class.getName() : BigInteger.class.getName();
            }
            case YEAR: {
                if ((flags & 2) != 0) {
                    return Date.class.getName();
                }
                return Short.class.getName();
            }
            case BIT: {
                return len == 1 ? Boolean.class.getName() : "[B";
            }
            case VARSTRING: 
            case VARCHAR: 
            case STRING: {
                return binary ? "[B" : String.class.getName();
            }
        }
        return type.getClassName();
    }

    public String getClassName() {
        return this.className;
    }

    public int getSqlType() {
        return this.javaType;
    }

    public String getTypeName() {
        return this.name();
    }

    public short getType() {
        return this.mysqlType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    static {
        typeMap = new ColumnType[256];
        ColumnType[] columnTypeArray = ColumnType.values();
        int n = columnTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnType v;
            ColumnType.typeMap[v.mysqlType] = v = columnTypeArray[i];
        }
    }
}

