/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.BasePrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbParameterMetaData;
import org.mariadb.jdbc.MariaDbPreparedStatementServer;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class MariaDbPreparedStatementClient
extends BasePrepareStatement {
    private static Logger logger = LoggerFactory.getLogger(MariaDbPreparedStatementClient.class);
    protected ClientPrepareResult prepareResult;
    protected List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private String sqlQuery;
    private ParameterHolder[] parameters;
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbPreparedStatementClient(MariaDbConnection connection, String sql, int resultSetScrollType, int resultSetConcurrency, int autoGeneratedKeys) throws SQLException {
        super(connection, resultSetScrollType, resultSetConcurrency, autoGeneratedKeys);
        String key;
        this.sqlQuery = sql;
        if (this.options.cachePrepStmts) {
            key = this.protocol.getDatabase() + "-" + this.sqlQuery;
            this.prepareResult = (ClientPrepareResult)connection.getClientPrepareStatementCache().get(key);
        }
        if (this.prepareResult == null) {
            this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.rewritableParts(this.sqlQuery, this.protocol.noBackslashEscapes()) : ClientPrepareResult.parameterParts(this.sqlQuery, this.protocol.noBackslashEscapes());
            if (this.options.cachePrepStmts && sql.length() < 1024) {
                key = this.protocol.getDatabase() + "-" + this.sqlQuery;
                connection.getClientPrepareStatementCache().put(key, this.prepareResult);
            }
        }
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public MariaDbPreparedStatementClient clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbPreparedStatementClient clone = (MariaDbPreparedStatementClient)super.clone(connection);
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        int i;
        for (i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("Parameter at position " + (i + 1) + " is not set");
            ExceptionMapper.throwException(new SQLException("Parameter at position " + (i + 1) + " is not set", "07004"), this.connection, this);
        }
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys, this.protocol.getAutoIncrementIncrement());
            if (this.queryTimeout != 0 && this.canUseServerTimeout) {
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters, this.queryTimeout);
            } else {
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters);
            }
            this.results.commandEnd();
            i = this.results.getResultSet() != null ? 1 : 0;
            return i != 0;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.hasLongData = false;
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            this.results.commandEnd();
            int[] nArray = this.results.getCmdInformation().getUpdateCounts();
            return nArray;
        }
        catch (SQLException sqle) {
            this.results.commandEnd();
            throw this.executeBatchExceptionEpilogue(sqle, this.results.getCmdInformation(), size, this.results.isRewritten());
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            this.results.commandEnd();
            long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
            return lArray;
        }
        catch (SQLException sqle) {
            throw this.executeBatchExceptionEpilogue(sqle, this.results.getCmdInformation(), size, this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable());
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    protected void executeInternalBatch(int size) throws SQLException {
        this.executeQueryPrologue(true);
        this.results.reset(0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, this.autoGeneratedKeys);
        if (this.protocol.executeBatchClient(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList, this.hasLongData)) {
            return;
        }
        SQLException exception = null;
        if (this.queryTimeout > 0) {
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                this.protocol.stopIfInterrupted();
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (SQLException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
        } else {
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (SQLException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    public void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            logger.error("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        try (MariaDbPreparedStatementServer ssps = new MariaDbPreparedStatementServer(this.connection, this.sqlQuery, 1004, 1007, 2);){
            this.resultSetMetaData = ssps.getMetaData();
            this.parameterMetaData = ssps.getParameterMetaData();
        }
        catch (SQLException sqle) {
            this.parameterMetaData = new MariaDbParameterMetaData(null);
        }
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }
}

