/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.BasePrepareStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbPreparedStatementServer;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class MariaDbPreparedStatementClient
extends BasePrepareStatement {
    private static Logger logger = LoggerFactory.getLogger(MariaDbPreparedStatementClient.class);
    private String sqlQuery;
    protected ClientPrepareResult prepareResult;
    private ParameterHolder[] parameters;
    protected List<ParameterHolder[]> parameterList = new ArrayList<ParameterHolder[]>();
    private ResultSetMetaData resultSetMetaData = null;
    private ParameterMetaData parameterMetaData = null;

    public MariaDbPreparedStatementClient(MariaDbConnection connection, String sql, int resultSetScrollType) throws SQLException {
        super(connection, resultSetScrollType);
        String key;
        this.sqlQuery = sql;
        if (this.options.cachePrepStmts) {
            key = this.protocol.getDatabase() + "-" + this.sqlQuery;
            this.prepareResult = (ClientPrepareResult)connection.getClientPrepareStatementCache().get(key);
        }
        if (this.prepareResult == null) {
            this.prepareResult = this.options.rewriteBatchedStatements ? ClientPrepareResult.rewritableParts(this.sqlQuery, connection.noBackslashEscapes) : ClientPrepareResult.parameterParts(this.sqlQuery, connection.noBackslashEscapes);
            if (this.options.cachePrepStmts && sql.length() < 1024) {
                key = this.protocol.getDatabase() + "-" + this.sqlQuery;
                connection.getClientPrepareStatementCache().put(key, this.prepareResult);
            }
        }
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public MariaDbPreparedStatementClient clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbPreparedStatementClient clone = (MariaDbPreparedStatementClient)super.clone(connection);
        clone.sqlQuery = this.sqlQuery;
        clone.prepareResult = this.prepareResult;
        clone.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
        clone.resultSetMetaData = this.resultSetMetaData;
        clone.parameterMetaData = this.parameterMetaData;
        return clone;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeInternal(this.getFetchSize());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.execute()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    protected boolean executeInternal(int fetchSize) throws SQLException {
        int i;
        for (i = 0; i < this.prepareResult.getParamCount(); ++i) {
            if (this.parameters[i] != null) continue;
            logger.error("Parameter at position " + (i + 1) + " is not set");
            ExceptionMapper.throwException(new SQLException("Parameter at position " + (i + 1) + " is not set", "07004"), this.connection, this);
        }
        this.lock.lock();
        try {
            this.executeQueryPrologue();
            this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.protocol.getAutoIncrementIncrement());
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameters);
            this.results.commandEnd();
            i = this.results.getResultSet() != null ? 1 : 0;
            return i != 0;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ParameterHolder[] holder = new ParameterHolder[this.prepareResult.getParamCount()];
        for (int i = 0; i < holder.length; ++i) {
            holder[i] = this.parameters[i];
            if (holder[i] != null) continue;
            logger.error("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
            throw ExceptionMapper.getSqlException("You need to set exactly " + this.prepareResult.getParamCount() + " parameters on the prepared statement");
        }
        this.parameterList.add(holder);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void clearBatch() {
        this.parameterList.clear();
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new int[0];
        }
        boolean rewritten = this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable();
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            if (!rewritten) {
                int[] nArray = this.results.getCmdInformation().getUpdateCounts();
                return nArray;
            }
            int[] nArray = this.results.getCmdInformation().getRewriteUpdateCounts();
            return nArray;
        }
        catch (SQLException sqle) {
            throw this.executeBatchExceptionEpilogue(sqle, this.results.getCmdInformation(), size, rewritten);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkClose();
        int size = this.parameterList.size();
        if (size == 0) {
            return new long[0];
        }
        boolean rewritten = this.options.rewriteBatchedStatements && this.prepareResult.isQueryMultiValuesRewritable();
        this.lock.lock();
        try {
            this.executeInternalBatch(size);
            if (!rewritten) {
                long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
                return lArray;
            }
            long[] lArray = this.results.getCmdInformation().getRewriteLargeUpdateCounts();
            return lArray;
        }
        catch (SQLException sqle) {
            throw this.executeBatchExceptionEpilogue(sqle, this.results.getCmdInformation(), size, rewritten);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    protected void executeInternalBatch(int size) throws SQLException {
        this.executeQueryPrologue();
        this.results.reset(0, true, size, false, this.resultSetScrollType);
        if (this.options.rewriteBatchedStatements) {
            if (this.prepareResult.isQueryMultiValuesRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList, true);
                return;
            }
            if (this.prepareResult.isQueryMultipleRewritable()) {
                this.protocol.executeBatchRewrite(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList, false);
                return;
            }
        }
        if (this.options.useBatchMultiSend) {
            this.protocol.executeBatchMulti(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList);
        } else {
            SQLException exception = null;
            for (int batchQueriesCount = 0; batchQueriesCount < size; ++batchQueriesCount) {
                try {
                    this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.prepareResult, this.parameterList.get(batchQueriesCount));
                    continue;
                }
                catch (SQLException e) {
                    if (this.options.continueBatchOnError) {
                        exception = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        this.results.commandEnd();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClose();
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (this.resultSetMetaData == null) {
            this.setParametersData();
        }
        return this.resultSetMetaData;
    }

    @Override
    protected void setParameter(int parameterIndex, ParameterHolder holder) throws SQLException {
        if (parameterIndex < 1 || parameterIndex >= this.prepareResult.getParamCount() + 1) {
            logger.error("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
            throw ExceptionMapper.getSqlException("Could not set parameter at position " + parameterIndex + " (values vas " + holder.toString() + ")");
        }
        this.parameters[parameterIndex - 1] = holder;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClose();
        if (this.parameterMetaData == null) {
            this.setParametersData();
        }
        return this.parameterMetaData;
    }

    private void setParametersData() throws SQLException {
        MariaDbPreparedStatementServer ssps = new MariaDbPreparedStatementServer(this.connection, this.sqlQuery, 1004, true);
        this.resultSetMetaData = ssps.getMetaData();
        this.parameterMetaData = ssps.getParameterMetaData();
        ssps.close();
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.prepareResult.getParamCount()];
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.statementEventListeners.isEmpty()) {
            return;
        }
    }

    protected int getParameterCount() {
        return this.prepareResult.getParamCount();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("sql : '" + this.sqlQuery + "'");
        sb.append(", parameters : [");
        for (int i = 0; i < this.parameters.length; ++i) {
            ParameterHolder holder = this.parameters[i];
            if (holder == null) {
                sb.append("null");
            } else {
                sb.append(holder.toString());
            }
            if (i == this.parameters.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    protected ClientPrepareResult getPrepareResult() {
        return this.prepareResult;
    }
}

