/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol.authentication;

import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.SendClearPasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendGssApiAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendNativePasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendOldPasswordAuthPacket;
import org.mariadb.jdbc.internal.com.send.SendPamAuthPacket;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;

public class DefaultAuthenticationProvider {
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    public static final String GSSAPI_CLIENT = "auth_gssapi_client";
    public static final String DIALOG = "dialog";

    public static InterfaceAuthSwitchSendResponsePacket processAuthPlugin(PacketInputStream reader, String plugin, String password, byte[] authData, int seqNo, String passwordCharacterEncoding) throws SQLException {
        switch (plugin) {
            case "mysql_native_password": {
                return new SendNativePasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
            }
            case "mysql_old_password": {
                return new SendOldPasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
            }
            case "mysql_clear_password": {
                return new SendClearPasswordAuthPacket(password, authData, seqNo, passwordCharacterEncoding);
            }
            case "dialog": {
                return new SendPamAuthPacket(reader, password, authData, seqNo, passwordCharacterEncoding);
            }
            case "auth_gssapi_client": {
                return new SendGssApiAuthPacket(reader, password, authData, seqNo, passwordCharacterEncoding);
            }
        }
        throw new SQLException("Client does not support authentication protocol requested by server. Consider upgrading MariaDB client. plugin was = " + plugin, "08004", 1251);
    }
}

