/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.io.input;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.input.StandardPacketInputStream;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.util.Utils;

public class DecompressPacketInputStream
implements PacketInputStream {
    private static Logger logger = LoggerFactory.getLogger(StandardPacketInputStream.class);
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final int MAX_PACKET_SIZE = 0xFFFFFF;
    private byte[] header = new byte[7];
    private byte[] reusableArray = new byte[1024];
    private byte[] cacheData = new byte[0];
    private int cachePos;
    private int cacheEnd;
    private BufferedInputStream inputStream;
    private int packetSeq;
    private int compressPacketSeq;
    private int maxQuerySizeToLog;
    private int lastPacketLength;
    private String serverThreadLog = "";

    public DecompressPacketInputStream(BufferedInputStream in, int maxQuerySizeToLog) {
        this.inputStream = in;
        this.maxQuerySizeToLog = maxQuerySizeToLog;
    }

    @Override
    public Buffer getPacket(boolean reUsable) throws IOException {
        return new Buffer(this.getPacketArray(reUsable));
    }

    @Override
    public byte[] getPacketArray(boolean reUsable) throws IOException {
        byte[] packet;
        byte[] cachePacket = this.getNextCachePacket();
        if (cachePacket != null) {
            return cachePacket;
        }
        do {
            this.readBlocking(this.header, 0, 7, true);
            int compressedLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
            this.compressPacketSeq = this.header[3] & 0xFF;
            int decompressedLength = (this.header[4] & 0xFF) + ((this.header[5] & 0xFF) << 8) + ((this.header[6] & 0xFF) << 16);
            byte[] rawBytes = reUsable && decompressedLength == 0 && compressedLength < 1024 ? this.reusableArray : new byte[decompressedLength != 0 ? decompressedLength : compressedLength];
            this.readCompressBlocking(rawBytes, compressedLength, decompressedLength);
            if (logger.isTraceEnabled()) {
                logger.trace("send compress: length:(zlib:" + compressedLength + ",std:" + decompressedLength + ") comp_seq:" + this.compressPacketSeq + this.serverThreadLog + " packet:0x" + Utils.hexdump(this.header, this.maxQuerySizeToLog, 0, 7) + Utils.hexdump(rawBytes, this.maxQuerySizeToLog - 7, 0, compressedLength));
            }
            this.cache(rawBytes, decompressedLength == 0 ? compressedLength : decompressedLength);
        } while ((packet = this.getNextCachePacket()) == null);
        return packet;
    }

    private void readCompressBlocking(byte[] arr, int compressedLength, int decompressedLength) throws IOException {
        if (decompressedLength != 0) {
            byte[] compressedBuffer = new byte[compressedLength];
            this.readBlocking(compressedBuffer, 0, compressedLength, false);
            Inflater inflater = new Inflater();
            inflater.setInput(compressedBuffer);
            try {
                int actualUncompressBytes = inflater.inflate(arr);
                if (actualUncompressBytes != decompressedLength) {
                    throw new IOException("Invalid exception length after decompression " + actualUncompressBytes + ",expected " + decompressedLength);
                }
            }
            catch (DataFormatException dfe) {
                throw new IOException(dfe);
            }
            inflater.end();
        } else {
            this.readBlocking(arr, 0, compressedLength, false);
        }
    }

    private void readBlocking(byte[] arr, int offset, int length, boolean isHeader) throws IOException {
        int count;
        int remaining = length;
        int off = offset;
        do {
            if ((count = this.inputStream.read(arr, off, remaining)) < 0) {
                throw new EOFException("unexpected end of exception, read " + (length - remaining) + " bytes from " + length);
            }
            off += count;
        } while ((remaining -= count) > 0);
    }

    private void cache(byte[] rawBytes, int length) {
        if (this.cachePos >= this.cacheEnd) {
            this.cacheData = rawBytes;
            this.cachePos = 0;
            this.cacheEnd = length;
        } else {
            byte[] newCache = new byte[length + this.cacheEnd - this.cachePos];
            System.arraycopy(this.cacheData, this.cachePos, newCache, 0, this.cacheEnd - this.cachePos);
            System.arraycopy(rawBytes, 0, newCache, this.cacheEnd - this.cachePos, length);
            this.cacheData = newCache;
            this.cachePos = 0;
            this.cacheEnd = newCache.length;
        }
    }

    private byte[] getNextCachePacket() {
        int packetOffset = 0;
        while (this.cacheEnd > this.cachePos + 4 + packetOffset * 0x1000003) {
            this.lastPacketLength = (this.cacheData[this.cachePos + packetOffset * 0x1000003] & 0xFF) + ((this.cacheData[this.cachePos + packetOffset * 0x1000003 + 1] & 0xFF) << 8) + ((this.cacheData[this.cachePos + packetOffset * 0x1000003 + 2] & 0xFF) << 16);
            if (this.lastPacketLength == 0xFFFFFF) {
                ++packetOffset;
                continue;
            }
            if (this.cacheEnd >= this.cachePos + 4 + packetOffset * 0x1000003 + this.lastPacketLength) {
                if (packetOffset == 0) {
                    this.packetSeq = this.cacheData[this.cachePos + 3];
                    if (this.cacheEnd - (this.cachePos + 4) < this.lastPacketLength) continue;
                    byte[] packet = new byte[this.lastPacketLength];
                    System.arraycopy(this.cacheData, this.cachePos + 4, packet, 0, this.lastPacketLength);
                    if (logger.isTraceEnabled()) {
                        logger.trace("read packet : seq=" + this.packetSeq + " len:" + this.lastPacketLength + this.serverThreadLog + " content:0x" + Utils.hexdump(this.cacheData, this.maxQuerySizeToLog, this.cachePos + 4, this.lastPacketLength));
                    }
                    this.cachePos += 4 + this.lastPacketLength;
                    return packet;
                }
                byte[] packet = new byte[this.lastPacketLength + packetOffset * 0xFFFFFF];
                int offset = 0;
                do {
                    this.lastPacketLength = (this.cacheData[this.cachePos] & 0xFF) + ((this.cacheData[this.cachePos + 1] & 0xFF) << 8) + ((this.cacheData[this.cachePos + 2] & 0xFF) << 16);
                    this.packetSeq = this.cacheData[this.cachePos + 3];
                    System.arraycopy(this.cacheData, this.cachePos + 4, packet, offset, this.lastPacketLength);
                    offset += this.lastPacketLength;
                    if (logger.isTraceEnabled()) {
                        logger.trace("read packet : seq=" + this.packetSeq + " len:" + this.lastPacketLength + this.serverThreadLog + " content:0x" + Utils.hexdump(this.cacheData, this.maxQuerySizeToLog, this.cachePos + 4, this.lastPacketLength));
                    }
                    this.cachePos += 4 + this.lastPacketLength;
                } while (this.lastPacketLength == 0xFFFFFF);
                return packet;
            }
            return null;
        }
        return null;
    }

    @Override
    public int getLastPacketLength() {
        return this.lastPacketLength;
    }

    @Override
    public int getLastPacketSeq() {
        return this.packetSeq;
    }

    @Override
    public int getCompressLastPacketSeq() {
        return this.compressPacketSeq;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void setServerThreadId(long serverThreadId, Boolean isMaster) {
        this.serverThreadLog = " conn:" + serverThreadId + (isMaster != null ? "(" + (isMaster != false ? "M" : "S") + ")" : "");
    }
}

