/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.dao.CmdInformation;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static final ScheduledThreadPoolExecutor timeoutScheduler = SchedulerServiceProviderHolder.getTimeoutScheduler();
    private static final Logger logger = LoggerFactory.getLogger(MariaDbStatement.class);
    protected final ReentrantLock lock;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected Future<?> timerTaskFuture;
    protected Runnable timerTaskRunnable;
    protected volatile boolean closed = false;
    protected int queryTimeout;
    protected long maxRows;
    protected Results results;
    protected final int resultSetScrollType;
    protected final int resultSetConcurrency;
    protected final Options options;
    protected int fetchSize;
    protected final boolean canUseServerTimeout;
    protected volatile boolean executing;
    private boolean warningsCleared;
    private boolean mustCloseOnCompletion = false;
    private List<String> batchQueries;
    private boolean isTimedout;
    private int maxFieldSize;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType, int resultSetConcurrency) throws SQLException {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.canUseServerTimeout = connection.canUseServerTimeout();
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
    }

    public MariaDbStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = connection;
        clone.protocol = connection.getProtocol();
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.closed = false;
        clone.warningsCleared = true;
        clone.fetchSize = 0;
        clone.maxRows = 0L;
        return clone;
    }

    protected void setTimerTask() {
        assert (this.timerTaskFuture == null);
        this.timerTaskRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    MariaDbStatement.this.isTimedout = true;
                    MariaDbStatement.this.protocol.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        this.timerTaskFuture = timeoutScheduler.schedule(this.timerTaskRunnable, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryPrologue(boolean forceUseOfTimer) throws SQLException {
        this.executing = true;
        if (this.closed) {
            throw new SQLException("execute() is called on closed statement");
        }
        this.protocol.prolog(this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0 && (!this.canUseServerTimeout || forceUseOfTimer)) {
            this.setTimerTask();
        }
    }

    private void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            timeoutScheduler.remove(this.timerTaskRunnable);
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected SQLException executeExceptionEpilogue(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.isTimedout) {
            return new SQLTimeoutException("(conn:" + this.getServerThreadId() + ") Query timed out", "JZ0002", 1317, sqle);
        }
        SQLException sqlException = ExceptionMapper.getException(sqle, this.connection, this, this.queryTimeout != 0);
        logger.error("error executing query", sqlException);
        return sqlException;
    }

    protected void executeEpilogue() {
        this.stopTimeoutTask();
        this.isTimedout = false;
        this.executing = false;
    }

    protected void executeBatchEpilogue() {
        this.executing = false;
        this.stopTimeoutTask();
        this.isTimedout = false;
        this.clearBatch();
    }

    private SQLException handleFailoverAndTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.isTimedout) {
            sqle = new SQLTimeoutException("(conn:" + this.getServerThreadId() + ") Query timed out", "JZ0002", 1317, sqle);
        }
        return sqle;
    }

    protected BatchUpdateException executeBatchExceptionEpilogue(SQLException initialSqle, CmdInformation cmdInformation, int size) {
        int[] ret;
        SQLException sqle = this.handleFailoverAndTimeout(initialSqle);
        if (cmdInformation == null) {
            ret = new int[size];
            Arrays.fill(ret, -3);
        } else {
            ret = cmdInformation.getUpdateCounts();
        }
        sqle = ExceptionMapper.getException(sqle, this.connection, this, this.queryTimeout != 0);
        logger.error("error executing query", sqle);
        return new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret, (Throwable)sqle);
    }

    private boolean executeInternal(String sql, int fetchSize, int autoGeneratedKeys) throws SQLException {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, autoGeneratedKeys, this.protocol.getAutoIncrementIncrement());
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(Utils.nativeSql(sql, this.protocol.noBackslashEscapes())));
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    private String getTimeoutSql(String sql) {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR " + sql;
        }
        return sql;
    }

    public boolean testExecute(String sql, Charset charset) throws SQLException {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, this.fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, 2, this.protocol.getAutoIncrementIncrement());
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(Utils.nativeSql(sql, this.protocol.noBackslashEscapes())), charset);
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 2);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 1);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.results != null) {
                if (this.results.getFetchSize() != 0) {
                    this.skipMoreResults();
                }
                this.results.close();
            }
            this.protocol = null;
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.noStmtEventListeners()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max rows cannot be negative : asked for " + max);
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw new SQLException("max rows cannot be negative : setLargeMaxRows value is " + max);
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Query timeout rows cannot be negative : asked for " + seconds);
        }
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        block9: {
            this.checkClose();
            boolean locked = this.lock.tryLock();
            try {
                if (this.executing) {
                    this.protocol.cancelCurrentQuery();
                    break block9;
                }
                if (this.results == null || this.results.getFetchSize() == 0 || this.results.isFullyLoaded(this.protocol)) break block9;
                try {
                    this.protocol.cancelCurrentQuery();
                    this.skipMoreResults();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.results.removeFetchSize();
            }
            catch (SQLException e) {
                logger.error("error cancelling query", e);
                ExceptionMapper.throwException(e, this.connection, this);
            }
            finally {
                if (locked) {
                    this.lock.unlock();
                }
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors are not supported");
    }

    @Override
    public MariaDbConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.results != null) {
            return this.results.getGeneratedKeys(this.protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        return this.results != null ? this.results.getResultSet() : null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getUpdateCount();
        }
        return -1;
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getLargeUpdateCount();
        }
        return -1L;
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (SQLException e) {
            logger.debug("error skipMoreResults", e);
            ExceptionMapper.throwException(e, this.connection, this);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClose();
        return this.results != null && this.results.getMoreResults(current, this.protocol);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw new SQLException("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        if (sql == null) {
            throw ExceptionMapper.getSqlException("null cannot be set to addBatch( String sql)");
        }
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.internalBatchExecution(size);
            int[] nArray = this.results.getCmdInformation().getUpdateCounts();
            return nArray;
        }
        catch (SQLException initialSqlEx) {
            this.results.commandEnd();
            throw this.executeBatchExceptionEpilogue(initialSqlEx, this.results.getCmdInformation(), size);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void internalBatchExecution(int size) throws SQLException {
        this.executeQueryPrologue(true);
        this.results = new Results(this, 0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, 1, this.protocol.getAutoIncrementIncrement());
        this.protocol.executeBatchStmt(this.protocol.isMasterConnection(), this.results, this.batchQueries);
        this.results.commandEnd();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.mustCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.mustCloseOnCompletion;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) throws SQLException {
        if (this.mustCloseOnCompletion && !this.closed && this.results != null && resultSet.equals(this.results.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Cannot do an operation on a closed statement");
        }
    }

    public long getServerThreadId() {
        return this.protocol != null ? this.protocol.getServerThreadId() : -1L;
    }
}

