/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.CallParameter;
import org.mariadb.jdbc.MariaDbConnection;

public class CallableParameterMetaData
implements ParameterMetaData {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\s*(IN\\s+|OUT\\s+|INOUT\\s+)?([\\w\\d]+)\\s+(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*", 2);
    private static final Pattern RETURN_PATTERN = Pattern.compile("\\s*(UNSIGNED\\s+)?(\\w+)\\s*(\\([\\d,]+\\))?\\s*(CHARSET\\s+)?(\\w+)?\\s*", 2);
    private List<CallParameter> params = null;
    private final MariaDbConnection con;
    private String database;
    private final String name;
    private boolean valid;
    private boolean isFunction;

    public CallableParameterMetaData(MariaDbConnection con, String database, String name, boolean isFunction) {
        this.con = con;
        this.database = database != null ? database.replace("`", "") : null;
        this.name = name.replace("`", "");
        this.isFunction = isFunction;
    }

    public void readMetadataFromDbIfRequired() throws SQLException {
        if (this.valid) {
            return;
        }
        this.readMetadata();
        this.valid = true;
    }

    private int mapMariaDbTypeToJdbc(String str) {
        if ("BIT".equals(str = str.toUpperCase())) {
            return -7;
        }
        if ("TINYINT".equals(str)) {
            return -6;
        }
        if ("SMALLINT".equals(str)) {
            return 5;
        }
        if ("MEDIUMINT".equals(str)) {
            return 4;
        }
        if ("INT".equals(str)) {
            return 4;
        }
        if ("INTEGER".equals(str)) {
            return 4;
        }
        if ("LONG".equals(str)) {
            return 4;
        }
        if ("BIGINT".equals(str)) {
            return -5;
        }
        if ("INT24".equals(str)) {
            return 4;
        }
        if ("REAL".equals(str)) {
            return 8;
        }
        if ("FLOAT".equals(str)) {
            return 6;
        }
        if ("DECIMAL".equals(str)) {
            return 3;
        }
        if ("NUMERIC".equals(str)) {
            return 2;
        }
        if ("DOUBLE".equals(str)) {
            return 8;
        }
        if ("CHAR".equals(str)) {
            return 1;
        }
        if ("VARCHAR".equals(str)) {
            return 12;
        }
        if ("DATE".equals(str)) {
            return 91;
        }
        if ("TIME".equals(str)) {
            return 92;
        }
        if ("YEAR".equals(str)) {
            return 5;
        }
        if ("TIMESTAMP".equals(str)) {
            return 93;
        }
        if ("DATETIME".equals(str)) {
            return 93;
        }
        if ("TINYBLOB".equals(str)) {
            return -2;
        }
        if ("BLOB".equals(str)) {
            return -4;
        }
        if ("MEDIUMBLOB".equals(str)) {
            return -4;
        }
        if ("LONGBLOB".equals(str)) {
            return -4;
        }
        if ("TINYTEXT".equals(str)) {
            return 12;
        }
        if ("TEXT".equals(str)) {
            return -1;
        }
        if ("MEDIUMTEXT".equals(str)) {
            return -1;
        }
        if ("LONGTEXT".equals(str)) {
            return -1;
        }
        if ("ENUM".equals(str)) {
            return 12;
        }
        if ("SET".equals(str)) {
            return 12;
        }
        if ("GEOMETRY".equals(str)) {
            return -4;
        }
        if ("VARBINARY".equals(str)) {
            return -3;
        }
        return 1111;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] queryMetaInfos(boolean isFunction) throws SQLException {
        Statement preparedStatement = null;
        try {
            String[] stringArray;
            block12: {
                preparedStatement = this.con.prepareStatement("select param_list, returns, db, type from mysql.proc where name=? and db=" + (this.database != null ? "?" : "DATABASE()"));
                preparedStatement.setString(1, this.name);
                if (this.database != null) {
                    preparedStatement.setString(2, this.database);
                }
                ResultSet rs = null;
                try {
                    rs = preparedStatement.executeQuery();
                    if (!rs.next()) {
                        throw new SQLException((isFunction ? "function" : "procedure") + " `" + this.name + "` does not exist");
                    }
                    String paramList = rs.getString(1);
                    String functionReturn = rs.getString(2);
                    this.database = rs.getString(3);
                    this.isFunction = "FUNCTION".equals(rs.getString(4));
                    stringArray = new String[]{paramList, functionReturn};
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                    catch (SQLSyntaxErrorException sqlSyntaxErrorException) {
                        throw new SQLException("Access to metaData informations not granted for current user. Consider grant select access to mysql.proc  or avoid using parameter by name", sqlSyntaxErrorException);
                    }
                }
                rs.close();
            }
            return stringArray;
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private void parseFunctionReturnParam(String functionReturn) throws SQLException {
        if (functionReturn == null || functionReturn.length() == 0) {
            throw new SQLException(this.name + "is not a function returning value");
        }
        Matcher matcher = RETURN_PATTERN.matcher(functionReturn);
        if (!matcher.matches()) {
            throw new SQLException("can not parse return value definition :" + functionReturn);
        }
        CallParameter callParameter = this.params.get(0);
        callParameter.setOutput(true);
        callParameter.setSigned(matcher.group(1) == null);
        callParameter.setTypeName(matcher.group(2).trim());
        callParameter.setSqlType(this.mapMariaDbTypeToJdbc(callParameter.getTypeName()));
        String scale = matcher.group(3);
        if (scale != null) {
            scale = scale.replace("(", "").replace(")", "").replace(" ", "");
            callParameter.setScale(Integer.valueOf(scale));
        }
    }

    private void parseParamList(boolean isFunction, String paramList) throws SQLException {
        this.params = new ArrayList<CallParameter>();
        if (isFunction) {
            this.params.add(new CallParameter());
        }
        Matcher matcher2 = PARAMETER_PATTERN.matcher(paramList);
        while (matcher2.find()) {
            CallParameter callParameter = new CallParameter();
            String direction = matcher2.group(1);
            if (direction != null) {
                direction = direction.trim();
            }
            callParameter.setName(matcher2.group(2).trim());
            callParameter.setSigned(matcher2.group(3) == null);
            callParameter.setTypeName(matcher2.group(4).trim().toUpperCase());
            if (direction == null || direction.equalsIgnoreCase("IN")) {
                callParameter.setInput(true);
            } else if (direction.equalsIgnoreCase("OUT")) {
                callParameter.setOutput(true);
            } else if (direction.equalsIgnoreCase("INOUT")) {
                callParameter.setInput(true);
                callParameter.setOutput(true);
            } else {
                throw new SQLException("unknown parameter direction " + direction + "for " + callParameter.getName());
            }
            callParameter.setSqlType(this.mapMariaDbTypeToJdbc(callParameter.getTypeName()));
            String scale = matcher2.group(5);
            if (scale != null) {
                if ((scale = scale.trim().replace("(", "").replace(")", "").replace(" ", "")).contains(",")) {
                    scale = scale.substring(0, scale.indexOf(","));
                }
                callParameter.setScale(Integer.valueOf(scale));
            }
            this.params.add(callParameter);
        }
    }

    private void readMetadata() throws SQLException {
        if (this.valid) {
            return;
        }
        String[] metaInfos = this.queryMetaInfos(this.isFunction);
        String paramList = metaInfos[0];
        String functionReturn = metaInfos[1];
        this.parseParamList(this.isFunction, paramList);
        if (this.isFunction) {
            this.parseFunctionReturnParam(functionReturn);
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.size();
    }

    private CallParameter getParam(int index) throws SQLException {
        if (index < 1 || index > this.params.size()) {
            throw new SQLException("invalid parameter index " + index);
        }
        this.readMetadataFromDbIfRequired();
        return this.params.get(index - 1);
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParam(param).getCanBeNull();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParam(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParam(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParam(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParam(param).getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParam(param).getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParam(param).getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        CallParameter callParameter = this.getParam(param);
        if (callParameter.isInput() && callParameter.isOutput()) {
            return 2;
        }
        if (callParameter.isInput()) {
            return 1;
        }
        if (callParameter.isOutput()) {
            return 4;
        }
        return 0;
    }

    public String getName(int param) throws SQLException {
        return this.getParam(param).getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

