/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerImpl;
import org.mariadb.jdbc.internal.util.scheduler.DynamicSizedSchedulerInterface;
import org.mariadb.jdbc.internal.util.scheduler.FixedSizedSchedulerImpl;
import org.mariadb.jdbc.internal.util.scheduler.MariaDbThreadFactory;

public class SchedulerServiceProviderHolder {
    public static SchedulerProvider DEFAULT_PROVIDER = new SchedulerProvider(){

        @Override
        public DynamicSizedSchedulerInterface getScheduler(int minimumThreads) {
            return new DynamicSizedSchedulerImpl(minimumThreads);
        }

        @Override
        public ScheduledThreadPoolExecutor getFixedSizeScheduler(int minimumThreads) {
            return new FixedSizedSchedulerImpl(minimumThreads);
        }

        @Override
        public ScheduledThreadPoolExecutor getTimeoutScheduler() {
            ScheduledThreadPoolExecutor timeoutScheduler = new ScheduledThreadPoolExecutor(1, new MariaDbThreadFactory());
            timeoutScheduler.setRemoveOnCancelPolicy(true);
            return timeoutScheduler;
        }

        @Override
        public ThreadPoolExecutor getBulkScheduler() {
            return new ThreadPoolExecutor(5, 100, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new MariaDbThreadFactory());
        }
    };
    private static volatile SchedulerProvider currentProvider = null;

    public static void setSchedulerProvider(SchedulerProvider newProvider) {
        currentProvider = newProvider;
    }

    public static SchedulerProvider getSchedulerProvider() {
        SchedulerProvider result = currentProvider;
        if (result == null) {
            return DEFAULT_PROVIDER;
        }
        return result;
    }

    public static DynamicSizedSchedulerInterface getScheduler(int initialThreadCount) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getScheduler(initialThreadCount);
    }

    public static ScheduledExecutorService getFixedSizeScheduler(int initialThreadCount) {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getFixedSizeScheduler(initialThreadCount);
    }

    public static ScheduledExecutorService getTimeoutScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getTimeoutScheduler();
    }

    public static ThreadPoolExecutor getBulkScheduler() {
        return SchedulerServiceProviderHolder.getSchedulerProvider().getBulkScheduler();
    }

    public static interface SchedulerProvider {
        public DynamicSizedSchedulerInterface getScheduler(int var1);

        public ScheduledExecutorService getFixedSizeScheduler(int var1);

        public ScheduledThreadPoolExecutor getTimeoutScheduler();

        public ThreadPoolExecutor getBulkScheduler();
    }
}

