/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.mariadb.jdbc.internal.packet.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.packet.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Utils;

public class SendNativePasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendNativePasswordAuthPacket(String password, byte[] authData, int packSeq) {
        super(packSeq, authData, password);
    }

    @Override
    public void send(OutputStream os) throws IOException {
        PacketOutputStream writer = (PacketOutputStream)os;
        try {
            writer.startPacket(this.packSeq);
            writer.write(Utils.encryptPassword(this.password, this.authData));
            writer.finishPacketWithoutRelease(false);
            writer.releaseBuffer();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
    }
}

