/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.lang.reflect.Method;

public class PidFactory {
    private static PidRequestInter pidRequest = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PidRequestInter getInstance() {
        if (pidRequest != null) return pidRequest;
        Class<PidFactory> clazz = PidFactory.class;
        synchronized (PidFactory.class) {
            if (pidRequest != null) return pidRequest;
            try {
                Class<?> platformClass = Class.forName("com.sun.jna.Platform");
                Method isLinuxMethod = platformClass.getMethod("isLinux", new Class[0]);
                Boolean isLinux = (Boolean)isLinuxMethod.invoke(platformClass, new Object[0]);
                if (isLinux.booleanValue()) {
                    pidRequest = new PidRequestInter(){

                        @Override
                        public String getPid() {
                            return String.valueOf(CLibrary.INSTANCE.getpid());
                        }
                    };
                } else {
                    Method isWindowsMethod = platformClass.getMethod("isWindows", new Class[0]);
                    Boolean isWindows = (Boolean)isWindowsMethod.invoke(platformClass, new Object[0]);
                    if (isWindows.booleanValue()) {
                        pidRequest = new PidRequestInter(){

                            @Override
                            public String getPid() {
                                return String.valueOf(Kernel32.INSTANCE.GetCurrentProcessId());
                            }
                        };
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pidRequest != null) return pidRequest;
            pidRequest = new PidRequestInter(){

                @Override
                public String getPid() {
                    return null;
                }
            };
            // ** MonitorExit[var0] (shouldn't be in output)
            return pidRequest;
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int getpid();
    }

    public static interface PidRequestInter {
        public String getPid();
    }
}

