/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class MultiVariableIntExecutionResult
implements MultiExecutionResult {
    private Statement statement = null;
    private boolean moreResultAvailable;
    private int fetchSize;
    private boolean selectPossible;
    private boolean canHaveCallableResultset;
    public Deque<ExecutionResult> cachedExecutionResults;
    private MariaSelectResultSet resultSet = null;
    private List<Long> insertId;
    private List<Integer> affectedRows;

    public MultiVariableIntExecutionResult(Statement statement, int size, int fetchSize, boolean selectPossible) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = false;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        this.affectedRows = new ArrayList<Integer>(size);
        this.insertId = new ArrayList<Long>(size);
    }

    @Override
    public void addResultSet(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.resultSet = result;
        this.insertId.add(-2L);
        this.affectedRows.add(-1);
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId.add(insertId);
        this.affectedRows.add((int)affectedRows);
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        long[] ret = new long[this.insertId.size()];
        Iterator<Long> iterator = this.insertId.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    @Override
    public int[] getAffectedRows() {
        int[] ret = new int[this.affectedRows.size()];
        Iterator<Integer> iterator = this.affectedRows.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows.size() > 0;
    }

    @Override
    public int getFirstAffectedRows() {
        return this.affectedRows.get(0);
    }

    public void addStatsError() {
        this.insertId.add(new Long(-3L));
        this.affectedRows.add(-3);
    }

    @Override
    public void updateResultsForRewrite(int waitedSize, boolean hasException) {
        long totalAffectedRows = 0L;
        Iterator<Integer> iterator = this.affectedRows.iterator();
        while (iterator.hasNext()) {
            totalAffectedRows += (long)iterator.next().intValue();
        }
        int realSize = Math.max(waitedSize, this.affectedRows.size());
        int resultVal = hasException ? -3 : (totalAffectedRows == (long)realSize ? 1 : -2);
        Object[] arr = new Integer[realSize];
        Arrays.fill(arr, (Object)resultVal);
        this.affectedRows = Arrays.asList(arr);
    }

    @Override
    public void updateResultsMultiple(int waitedSize, boolean hasException) {
        if (hasException) {
            for (int i = this.affectedRows.size(); i < waitedSize; ++i) {
                this.addStatsError();
            }
        }
    }

    @Override
    public MariaSelectResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public boolean hasMoreResultAvailable() {
        return this.moreResultAvailable;
    }

    protected void setMoreResultAvailable(boolean moreResultAvailable) {
        this.moreResultAvailable = moreResultAvailable;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    @Override
    public boolean isSelectPossible() {
        return this.selectPossible;
    }

    @Override
    public boolean isCanHaveCallableResultset() {
        return this.canHaveCallableResultset;
    }

    @Override
    public Deque<ExecutionResult> getCachedExecutionResults() {
        return this.cachedExecutionResults;
    }

    public void addResult(ExecutionResult executionResult) {
        this.cachedExecutionResults.add(executionResult);
    }

    @Override
    public boolean isSingleExecutionResult() {
        return false;
    }
}

