/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ReaderParameter
implements ParameterHolder {
    private Reader reader;
    private long length;
    private boolean noBackslashEscapes;

    public ReaderParameter(Reader reader, long length, boolean noBackslashEscapes) {
        this.reader = reader;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
        if (reader.markSupported()) {
            try {
                reader.mark(1024);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ReaderParameter(Reader reader, boolean noBackslashEscapes) {
        this(reader, Long.MAX_VALUE, noBackslashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            ParameterWriter.write((OutputStream)os, this.reader, this.noBackslashEscapes);
        } else {
            ParameterWriter.write((OutputStream)os, this.reader, this.length, this.noBackslashEscapes);
        }
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        throw new IOException("Cannot use unsafe with Reader");
    }

    @Override
    public long getApproximateTextProtocolLength() throws IOException {
        return -1L;
    }

    @Override
    public void writeBinary(PacketOutputStream os) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            os.sendStream(this.reader);
        } else {
            os.sendStream(this.reader, this.length);
        }
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BLOB;
    }

    @Override
    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.reader.markSupported()) {
                this.reader.reset();
            }
            if (this.length == Long.MAX_VALUE) {
                ParameterWriter.write((OutputStream)baos, this.reader, this.noBackslashEscapes);
            } else {
                ParameterWriter.write((OutputStream)baos, this.reader, this.length, this.noBackslashEscapes);
            }
            byte[] bytes = baos.toByteArray();
            if (bytes.length < 1024) {
                return "<Buffer:" + new String(bytes, StandardCharsets.UTF_8) + ">";
            }
            return "<Buffer:" + new String(bytes, 0, 1024, StandardCharsets.UTF_8) + "...>";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean isLongData() {
        return true;
    }

    public boolean isStream() {
        return true;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

